
/*
   In this version we have added a draw() method,
   so the button now knows how to draw itself.

   We also added a setPressing() method, as an
   example of using a method to change an object,
   rather than just assigning a new value to
   a field variable.  This is going to be really
   useful as we start doing more sophisticated
   things with objects.
*/

import java.awt.*;

public class MyButton
{
   // All of the variables defining the button:

   int x;
   int y;
   int width;
   int height;                 // Rectangular bounds around button
   Color color = Color.white;  // Color of the button
   String label = "";          // The button's text label

   boolean isPressing;         // Whether the button is being pressed

   // CONSTRUCTOR TO CREATE A BUTTON WITH NO DATA FIELDS SET

   public MyButton() {
   }

   // CONSTRUCTOR TO CREATE A BUTTON WITH ALL ITS DATA FIELDS SET
   // NOTE: A CONSTRUCTOR IS NOT A METHOD.  IT'S A CONSTRUCTOR!  :-)

   public MyButton(int x, int y, int width, int height, Color color, String label) {
      this.x = x;
      this.y = y;
      this.width = width;
      this.height = height;
      this.color = color;
      this.label = label;
   }

   // THIS METHOD JUST SETS THE FIELD isPressing TO TRUE OR FALSE.
   // WE MUST DECLARE THIS METHOD TO BE TYPE "void", BECAUSE IT DOES NOT RETURN ANY VALUE.

   public void setPressing(boolean isPressing) {
      this.isPressing = isPressing;
   }

   // IMPLEMENT A METHOD TO SEE WHETHER THE BUTTON CONTAINS PIXEL x,y.

   public boolean contains(int px, int py) {
      return px >= x        &&
             px < x + width &&
             py >= y        &&
	     py < y + height ;
   }

   // A METHOD FOR THE BUTTON TO DRAW ITSELF

   public void draw(Graphics g) {

       // Draw the general shape of the button

       g.setColor(color);
       g.fill3DRect(x, y, width, height, ! isPressing);

       // Draw the text label of the button.

       g.setColor(Color.black);
       g.drawString(label, x + 25, y + 20);
   }
}

