
/*
   In this version we are focusing on two things:

       (1) working with arrays of objects
   and:
       (2) using for loops to iterate through arrays of objects.
*/

import java.awt.*;

public class applet7 extends BufferedApplet
{
   int w = 0, h = 0;

   // This is an array of MyButton objects, in which
   // each element is initialized with a MyButton constructor.

   MyButton button[] = 
      {
         new MyButton(100, 100, 150, 30, new Color(200, 235, 255), "I'm a button!"),    // button[0]
         new MyButton(400, 100, 150, 30, new Color(255, 215, 200), "I'm a toggle!"),    // button[1]
         new MyButton(400, 300, 150, 30, new Color(255, 225, 100), "I'm another one!"), // button[2]
         new MyButton(400, 300, 150, 30, new Color(255, 225, 100), "arrange buttons"),  // button[3]
      };


   // Variables for a light bulb that is turned on and off by the toggle button

   Color lightColor = new Color(255, 255, 128);
   boolean isLightTurnedOn = false;	           // State of a "light" that is turned on or off


   public void render(Graphics g) {

       // ANYTHING INSIDE THE if (w == 0) BLOCK WILL BE EXECUTED ONLY ONCE.

       if (w == 0) {

          // MAKE A NICE NEAT ARRANGEMENT OF THE BUTTONS

          for (int i = 0 ; i < button.length ; i++) {
	     button[i].x = 300;
	     button[i].y = 100 + i * 50;
	  }
       }



       // FIND OUT THE WIDTH AND HEIGHT OF THE APPLET WINDOW.

       w = getWidth();
       h = getHeight();


       //------------------- HANDLE USER INPUT ------------------------


       // REARRANGE THE BUTTONS IF THE USER HITS THE '2' KEY.

       if (wasKeyDown['2'] && ! keyDown['2']) {
          rearrangeButtons();
       }


       // CLICK-DOWN LOGIC:

       if (! wasMouseDown && mouseDown) {

          // FOR EACH BUTTON:
          //     IF BUTTON CONTAINS THE MOUSE X,Y:
          //        SET THE BUTTON TO isPressed.


          // NOTE: I REPLACED THIS

          // b1.isPressing = b1.contains(mouseX, mouseY) ;
          // b2.isPressing = b2.contains(mouseX, mouseY) ;

	  // WITH THIS.

          for (int i = 0 ; i < button.length ; i++)
             button[i].setPressing ( button[i].contains(mouseX, mouseY) );
       }


       // CLICK-UP LOGIC:

       if (! mouseDown && wasMouseDown)

	  // IF THE USER HAS JUST RELEASED button[1]:

	  if (button[1].isPressing)

	     // IF THE MOUSE IS STILL OVER THE BUTTON,
	     // FLIP THE LIGHT SWITCH ON OR OFF.

	     if (button[1].contains(mouseX, mouseY))
	        isLightTurnedOn = ! isLightTurnedOn;


	  // IF THE USER HAS JUST RELEASED button[3]:

          if (button[3].isPressing) {

             // IF THE MOUSE IS STILL OVER THE BUTTON,
             // REARRANGE THE BUTTONS.

	     if (button[3].contains(mouseX, mouseY))
	        rearrangeButtons();
	  }



      // WHEN THE MOUSE BUTTON IS UP, THEN ALL BUTTONS UNPRESSED:

       if (! mouseDown)
          for (int i = 0 ; i < button.length ; i++)
             button[i].setPressing(false);



       //------------------- DRAW EVERYTHING ---------------------



       // CLEAR THE APPLET WINDOW.

       g.setColor(Color.white);
       g.fillRect(0, 0, w, h);



       // DRAW THE TWO BUTTONS.

       for (int i = 0 ; i < button.length ; i++)
          button[i].draw(g);


       // DRAW THE LIGHT BULB.

       // (1) Fill the light bulb with light, if the light is on.

       if (isLightTurnedOn) {
          g.setColor(lightColor);
          g.fillOval(w / 2 - 100, h - 300, 200, 200);
       }

       // (2) Draw the light bulb itself.

       g.setColor(Color.black);
       g.drawOval(w / 2 - 100, h - 300, 200, 200);
       g.fillOval(w / 2 - 15, h - 60, 30, 20);
       g.setColor(Color.gray);
       g.fillRect(w / 2 - 25, h - 103, 50, 53);
       g.setColor(Color.black);
       g.drawRect(w / 2 - 25, h - 103, 50, 53);
       g.drawString("I'm a light bulb!", w / 2 - 50, h - 200);



       // The next line forces render to get called repeatedly,
       // even if there are no mouse events.

       animating = true;
   }


   // BREAK OUT THE LOGIC FOR REARRANGING THE BUTTONS INTO A SEPARATE METHOD.

   void rearrangeButtons() {
          for (int i = 0 ; i < button.length ; i++) {
	     button[i].x = 100;
	     button[i].y = 100 + i * 50;
	  }
   }
}


