
/*
  THIS EXAMPLE APPLET SHOWS YOU HOW TO CREATE
  BUTTONS BY DEFINING YOUR OWN OBJECT CLASS.
*/

import java.awt.*;

public class applet6 extends BufferedApplet
{
   int w = 0, h = 0;

   // The two buttons are declared and also initialized, using the MyButton constructor.

   MyButton b1 = new MyButton(100, 100, 150, 30, new Color(200, 235, 255));
   MyButton b2 = new MyButton(400, 100, 150, 30, new Color(255, 215, 200));


   // Variables for a light bulb that is turned on and off by the toggle button

   Color lightColor = new Color(255, 255, 128);
   boolean isLightTurnedOn = false;	           // State of a "light" that is turned on or off


   public void render(Graphics g) {



       // FIND OUT THE WIDTH AND HEIGHT OF THE APPLET WINDOW.

       w = getWidth();
       h = getHeight();


       //------------------- HANDLE USER INPUT ------------------------

       /*
          WHEN THE USER CLICKS DOWN, SET EACH BUTTON'S BOOLEAN TO TRUE
	  IF THE MOUSE IS INSIDE THAT BUTTON.
       */

       if (! wasMouseDown && mouseDown) {
          b1.isPressing = b1.contains(mouseX, mouseY);    // Note that MyButton objects have
          b2.isPressing = b2.contains(mouseX, mouseY);    // their own "contains(...)" method.
       }

       /*
          WHEN THE USER CLICKS UP, THEN DO ALL "CLICK UP" LOGIC.
       */

       // IF THIS IS THE MOMENT THE MOUSE BUTTON IS GOING UP,

       if (! mouseDown && wasMouseDown)

	  // IF THE USER HAS PRESSED THE SECOND BUTTON,

	  if (b2.isPressing)

	     // IF THE MOUSE IS STILL OVER THE BUTTON,
	     // FLIP THE LIGHT SWITCH ON OR OFF.

	     if (b2.contains(mouseX, mouseY))
	        isLightTurnedOn = ! isLightTurnedOn;

       /*
          IF THE MOUSE BUTTON IS UP, THEN NO BUTTONS ARE PRESSED.
       */

       if (! mouseDown) {
          b1.isPressing = false;
          b2.isPressing = false;
       }


       //------------------- DRAW EVERYTHING ---------------------



       // CLEAR THE APPLET WINDOW.

       g.setColor(Color.white);
       g.fillRect(0, 0, w, h);



       // DRAW THE TWO BUTTONS.

       g.setColor(b1.color);
       g.fill3DRect(b1.x, b1.y, b1.width, b1.height, ! b1.isPressing);

       g.setColor(Color.black);
       g.drawString("I'm a button!", b1.x + 25, b1.y + 20);

       g.setColor(b2.color);
       g.fill3DRect(b2.x, b2.y, b2.width, b2.height, ! b2.isPressing);

       g.setColor(Color.black);
       g.drawString("I'm a toggle!", b2.x + 25, b2.y + 20);



       // DRAW THE LIGHT BULB.

       // Fill the light bulb with light, if the light is on.

       if (isLightTurnedOn) {
          g.setColor(lightColor);
          g.fillOval(w / 2 - 100, h - 300, 200, 200);
       }

       // Draw the light bulb itself.

       g.setColor(Color.black);
       g.drawOval(w / 2 - 100, h - 300, 200, 200);
       g.fillOval(w / 2 - 15, h - 60, 30, 20);
       g.setColor(Color.gray);
       g.fillRect(w / 2 - 25, h - 103, 50, 53);
       g.setColor(Color.black);
       g.drawRect(w / 2 - 25, h - 103, 50, 53);
       g.drawString("I'm a light bulb!", w / 2 - 50, h - 200);



       // The next line forces render to get called repeatedly,
       // even if there are no mouse events.

       animating = true;
   }
}

