
/*
THIS EXAMPLE APPLET SHOWS YOU HOW TO DETECT AND RESPOND
WHEN KEYS OF THE KEYBOARD ARE CLICKED DOWN OR UP.
*/

import java.awt.*;

public class applet4 extends BufferedApplet
{
	/*
	  The two lines below are an example of creating X and Y
	  coordinates that can be used to draw or fill a polygon.
	*/


	// initialize 4 points
	double X[] = { 100, 200, 300, 400};       // Array storing the X coordinates of the triangle
	double Y[] = { 400, 100, 100, 400};       // Array storing the Y coordinates of the triangle

	int w = 0; int h = 0;

	boolean dragging = false;
	int selected = -1;
	int radius = 10;
	boolean showLines = true;
	boolean showDots = true;
	int page = 0;  int lastPage = 2;
	
	public void render(Graphics g) {

		// Find out the width and the height of the applet window.

		w = getWidth();
		h = getHeight();

		if (wasKeyDown['.'] && !keyDown['.']) {
			page += 1;
			if (page > lastPage) page = 0;
		}

		if (wasKeyDown[','] && !keyDown[',']) {
			page -= 1;
			if (page < 0) page = lastPage;
		}
		 
		 
		if (page == 0) {
			if (!wasMouseDown && mouseDown) {
				dragging = true;
				selected = -1;
				for (int i = 0; i < X.length; i++) {
					if (((mouseX - X[i]) * (mouseX - X[i]) + (mouseY - Y[i]) * (mouseY - Y[i])) < radius * radius) {
						selected = i;
						System.out.println("selected " + i);
						break;
					}
				}
			}

			if (dragging && !mouseDown && wasMouseDown) {
				dragging = false;
				selected = -1;
			}

			if (dragging && selected >= 0 && selected < X.length) {
				X[selected] = mouseX;
				Y[selected] = mouseY;
			}

					
			if (!keyDown['l'] && wasKeyDown['l']) {
				showLines = !showLines;
			}

			if (!keyDown['d'] && wasKeyDown['d']) {
				showDots = !showDots;
			}

			// DRAW EVERYTHING
			g.setColor(Color.white);
			g.fillRect(0, 0, w, h);


			if (showDots) {
				g.setColor(Color.blue);
				for (int i = 0; i < X.length; i++) {
					double x = X[i];
					double y = Y[i];
					g.fillOval((int)(x - radius), (int)(y - radius), 2 * radius, 2 * radius);
				}
			}

			// The next line forces render to get called repeatedly,
			// even if there are no mouse events.
			bezier(g, X, Y);
		} else if (page == 1) {
			g.setColor(Color.white);
			g.fillRect(0, 0, w, h);

		} else if (page == 2) {
			g.setColor(Color.white);
			g.fillRect(0, 0, w, h);

		}

		g.drawString("Page: " + page + ".  " + mouseX + ", " + mouseY, 500, 100);
		animating = true;
	}
	
	public void bezier(Graphics g, double [] X, double[] Y) {
		double dt = 1.0/1024.0;
		double fromX = X[0];
		double fromY = Y[0];
		g.setColor(Color.green);
		for (double t = 0; t <= 1.0; t += dt) {
			double toX = lerp(t,	lerp(t, lerp(t, X[0], X[1]), lerp(t, X[1], X[2])),
									lerp(t, lerp(t, X[1], X[2]), lerp(t, X[2], X[3])));
			double toY = lerp(t,	lerp(t, lerp(t, Y[0], Y[1]), lerp(t, Y[1], Y[2])),
									lerp(t, lerp(t, Y[1], Y[2]), lerp(t, Y[2], Y[3])));
									
			g.drawLine((int)fromX, (int)fromY, (int)toX, (int)toY);
			fromX = toX;
			fromY = toY;
		}
		
		if (showLines) {
			g.setColor(Color.red);
			g.drawLine((int)X[0], (int)Y[0], (int)X[1], (int)Y[1]);
			g.drawLine((int)X[1], (int)Y[1], (int)X[2], (int)Y[2]);
			g.drawLine((int)X[2], (int)Y[2], (int)X[3], (int)Y[3]);
		}
	}
	
	public double lerp(double t, double a, double b) {
	
		return ((1-t) * a + t * b);
		
	}
}

