
// The following line makes sure that library methods are properly typed

// By the way, "awt" stands for Abstract Window Toolkit -- ie: the underlying
// graphics library that takes care of how to draw shapes and so forth.

import java.awt.*;

// Make sure your class is public, and that it extends BufferedApplet

public class myhomework1 extends BufferedApplet
{
   // It's convenient to make w and h global variables.
   // That way they can be available to be used within any method of the class.

   int w = 0, h = 0;

   // You can make any R,G,B color you want like this.  Feel free to experiment!!!

   Color offwhite = new Color(220, 220, 220);

   // This was to show what happens when you do or don't include "animating = true".

   int myCounter = 0;

   // You always need to have a render method -- but you have lots of flexibility
   // about what you put into it.  From this method, you can call lots of other
   // methods to parcel out the work of drawing things.

   public void render(Graphics g) {

       // We're asking the underlying AWT library to tell us the width
       // and height of the applet -- the same info that you specified
       // in your HTML file.

       w = getWidth();
       h = getHeight();

       // Clear the background every time before drawing anything.

       g.setColor(Color.white);
       g.fillRect(0, 0, w, h);

       // Here we are drawing the kooky shape we created in class.

       drawMyShape(g, offwhite, mouseX - 100, mouseY - 100, 70, 200);
       drawMyShape(g, Color.green, mouseX + 100, mouseY -  30, 200, 70);

       // If you uncomment "animating = true", the render() method gets called over
       // and over again.  Otherwise, it only gets called at mouse or keyboard events.

       myCounter++;

       // animating = true;
   }

   // We're using a method to draw a shape (which can vary in color, location and size).

   void drawMyShape(Graphics g, Color color, int x, int y, int w, int h) {

      g.setColor(color);
      g.fillRect(x, y, w, h);

      g.setColor(Color.black);
      g.drawRect(x, y, w, h);
      g.drawOval(x, y, w, h);

      // Notice that you can just concatenate strings by using the "+" sign.

      g.drawString("counter = " + myCounter + ", I'm drawing at " + x + " " + y, x, y);
   }
}

