
import java.awt.*;

public class TextLabel
{
   int fontHeight = 30, x = 0, y = 0;
   Font font = new Font("Times Roman", Font.PLAIN, fontHeight);

   // THIS IS AN EXAMPLE OF A TRANSPARENT COLOR

   Color shadowColor = new Color(0, 0, 0, 64);
   Color color = null;
   String text = "";
   Graphics g;

   // CONSTRUCTOR NEEDS TO KNOW LABEL TEXT AND x,y CENTER LOCATION

   public TextLabel(String text, int x, int y) {
      setText(text);
      setX(x);
      setY(y);
   }

   public Color getColor() { return color == null ? Color.white : color; }
   public String getText() { return text; }
   public int getX() { return x; }
   public int getY() { return y; }
   public boolean hasColor() { return color != null; }

   public void setColor(Color color) { this.color = color; }
   public void setText(String text) { this.text = text; }
   public void setX(int x) { this.x = x; }
   public void setY(int y) { this.y = y; }

   // MOVE THE OBJECT BY THIS AMOUNT

   public void move(int dx, int dy) {
      x += dx;
      y += dy;
   }

   public void moveTo(int x, int y) {
      this.x = x;
      this.y = y;
   }

   // SEE WHETHER THE OBJECT CONTAINS PIXEL x,y

   public boolean contains(int x, int y) {
      int width = stringWidth(text);
      int x0 = this.x - width/2, x1 = x0 + width;
      int y0 = this.y - fontHeight, y1 = y0 + 3 * fontHeight/2;
      return x >= x0 && x < x1 && y >= y0 && y < y1;
   }

   // DRAW THE OBJECT

   public void draw(Graphics g) {
      this.g = g;
      int width = stringWidth(text);
      int x0 = x - width/2, x1 = x0 + width;
      int y0 = y - fontHeight, y1 = y0 + 3 * fontHeight/2;

      g.setColor(shadowColor);
      g.fillRoundRect(x0-10 + 5, y0 + 5, x1-x0+20, y1-y0, fontHeight+1, fontHeight+1);
      g.setColor(getColor());
      g.fillRoundRect(x0-10, y0, x1-x0+20, y1-y0, fontHeight, fontHeight);
      g.setColor(Color.black);
      g.drawRoundRect(x0-10, y0, x1-x0+20, y1-y0, fontHeight, fontHeight);
      g.setFont(font);
      g.drawString(text, x0, (y0+y1)/2 + 2*fontHeight/5);
   }

   // GET THE WIDTH, IN PIXELS, OF A TEXT STRING

   int stringWidth(String str) { return g.getFontMetrics().stringWidth(str); }
}

