
import java.awt.*;
import drawable.*;

public class SceneApplet extends BufferedApplet
{
   int width, height;

   // CREATE A CAR AND ALL ITS COMPONENTS

   Group car1 = new Group();
   {
      car1.add(new Box (100, 250, 300, 100));
      car1.add(new Disk(100, 320, 100, 100)).setColor(Color.blue);
      car1.add(new Disk(300, 320, 100, 100)).setColor(Color.blue);
      car1.setColor(Color.red);
   }

   Group car2 = new Group();
   {
      car2.add(new Box ( 75, 200, 400, 150));
      car2.add(new Disk(100, 270, 150, 150)).setColor(Color.blue);
      car2.add(new Disk(300, 270, 150, 150)).setColor(Color.blue);
      car2.setColor(Color.green);
   }

   Group car = new Group();
   {
      car.add(car1);
      car.add(car2);
      car.setDisplayItem(0);
   }

   // CREATE A PERSON AND ALL OF ITS COMPONENTS

   Group person = new Group();
   {
      person.add(new Box(440, 120, 20, 200));
      person.add(new Disk(400, 100, 100, 100)).setColor(Color.pink);
      person.add(new Disk(420, 120, 20, 20));
      person.add(new Disk(460, 120, 20, 20));
      person.setColor(Color.black);
   }

   // THESE ARE ALL OF THE DRAWABLE OBJECTS

   Drawable drawables[] = {
       person,
       car,
   };

   // THESE ARE ALL OF THE TEXT LABELS

   TextLabel textLabels[] = {
       new TextLabel("Car" , 100, 100),
       new TextLabel("Fred", 250, 100),
   };

   Drawable selectedDrawable;
   TextLabel selectedTextLabel;
   int selectedX, selectedY;

   public void render(Graphics g) {
      width = getWidth();
      height = getHeight();

      // '1' AND '2' KEYS TOGGLE APPEARANCE OF CAR

      if (wasKeyDown['1'] && ! keyDown['1'])
         car.setDisplayItem(0);

      if (wasKeyDown['2'] && ! keyDown['2'])
         car.setDisplayItem(1);

      // HANDLE MOUSE BEING PRESSED DOWN

      if (! wasMouseDown && mouseDown)
         doMousePressedAction();

      // HANDLE MOUSE BEING DRAGGED

      if (mouseDown)
         doMouseDragAction();

      // CLEAR THE BACKGROUND

      g.setColor(Color.white);
      g.fillRect(0, 0, width, height);

      // DRAW THE OBJECTS

      for (int i = 0 ; i < drawables.length ; i++)
         drawables[i].draw(g);

      // DRAW THE TEXT LABELS

      for (int i = 0 ; i < textLabels.length ; i++)
         textLabels[i].draw(g);

      animating = true;
   }

   void doMousePressedAction() {
      selectedDrawable = null;
      selectedTextLabel = null;

      // FIND THE FRONT-MOST TEXT LABEL AT PIXEL, IF ANY

      for (int i = textLabels.length - 1 ; i >= 0 ; i--)
         if (textLabels[i].contains(mouseX, mouseY)) {
            selectedTextLabel = textLabels[i];
            selectedX = mouseX;
            selectedY = mouseY;
            return;
         }

      // FIND THE FRONT-MOST OBJECT AT PIXEL, IF ANY

      for (int i = drawables.length - 1 ; i >= 0 ; i--)
         if (drawables[i].contains(mouseX, mouseY)) {
            selectedDrawable = drawables[i];
            selectedX = mouseX;
            selectedY = mouseY;
            return;
        }
   }

   void doMouseDragAction() {

      // DRAG THE SELECTED OBJECT, IF ANY

      if (selectedDrawable != null) {
         selectedDrawable.move(mouseX - selectedX, mouseY - selectedY);
         selectedX = mouseX;
         selectedY = mouseY;
      }

      // DRAG THE SELECTED TEXT LABEL, IF ANY

      if (selectedTextLabel != null) {
         selectedTextLabel.move(mouseX - selectedX, mouseY - selectedY);
         selectedX = mouseX;
         selectedY = mouseY;
      }
   }
}

