////////////////////////////////////////////////////////////
// import required libraries
////////////////////////////////////////////////////////////
import processing.net.*;


////////////////////////////////////////////////////////////
// global variables
////////////////////////////////////////////////////////////
int port          = 9999;       // port number
boolean connected = false;      // client is connected

Server server;                  // server
Client client;                  // client

String XML = "";                // XML string from client
String data = "";               // accumulate string data from client 
String dataIn = "";             // data packet from client   
String IP = "";                 // client IP address 

int nXMLSize = 0;               // XML size  
int nStatus = 0;                // 0: wait for size    1: wait for XML   2: wait for END signal
int nTotalRecvSize = 0;         // how much data is received
int nCount = 0;                 // how many requestes are received

////////////////////////////////////////////////////////////
// basic functions
////////////////////////////////////////////////////////////

void setup() {
    // init window
    size(200, 200);
    background(0);
    
    // create server
    server = new Server(this, port);  
}

void draw() {  
    
    ////////////////////////////////////////
    // check availability
    ////////////////////////////////////////
    if (client == null) return;                // connected?
    if (client.available() < 1) return;        // client has something to say?

    
    ////////////////////////////////////////
    // receive data from client
    ////////////////////////////////////////
    dataIn = client.readString();          
    
    printStatus();           
    
    switch (nStatus) {
        case 0:  // wait for SIZE:xxxx        

            // get size of XML
            if (dataIn.indexOf("SIZE:") > -1) {
                String sXMLsize = dataIn.substring(5);
                nXMLSize = int(sXMLsize);
                println("## GET SIZE");
                
                server.write("RECV_SIZE");
                println("## WRITE RECV_SIZE");
                nStatus++;          
            }             
                                
            break;
            
        case 1: // wait for XML
            // read data from client until nXMLSize
            if (nTotalRecvSize < nXMLSize) {
                data = data + dataIn;
                nTotalRecvSize += dataIn.length();                
            } 
            
            // when finishing reading, say "END" to client
            if (nTotalRecvSize >= nXMLSize) {
                println("## GET all XML");
                nTotalRecvSize = 0;
                nStatus++;
                server.write("END");
                println("## WRITE END");
            }
            break;
       
        case 2: // wait for END
            // when client says "END", close connection
            if (dataIn.equals("END")) {
                println("## GET END");
                closeConnection();
            }
     
            break;                 
    }
}


void closeConnection() {
 
    String oldIP = IP;
    
    if (client != null) {
        println("## DISCONNECT");
        server.disconnect(client);
        client = null;
    } else {
        println("## NOT DISCONNECT");
    }

    XML = data;
    
    data           = "";
    dataIn         = "";
    IP             = "";

    nTotalRecvSize = 0;
    nStatus        = 0;
    nXMLSize       = 0;

    connected      = false;

    printStatus();
    
    println("DISCONNECT " + oldIP);
    println("////////////////////////////////////////");

}

void printStatus() {
    String sClient = "null";
    String sConnected = "true";
    
    if (client != null) sClient = "not null";
    if (!connected)     sConnected = "false";

    println("------------------------------");
    println("nCount          = " + nCount);
    println("client          = " + sClient);
    println("connected       = " + sConnected);
    println("nStatus         = " + nStatus);
    println("nXMLSize        = " + nXMLSize);
    println("nTotalRecvSize  = " + nTotalRecvSize);
    println("dataIn          = [" + dataIn + "]");
    println("xml             = [" + XML + "]");
    println("------------------------------");      
}
    
////////////////////////////////////////////////////////////
// when a new client is connected this function is invoked
////////////////////////////////////////////////////////////
void serverEvent(Server someServer, Client someClient) {

    if (nStatus == 0) {
        println("////////////////////////////////////////");
        println("CONNECTION from " + someClient.ip());
    
        nCount++;
        
        data           = "";
        dataIn         = "";
        IP             = "";
        XML            = "";
        
        nTotalRecvSize = 0;
        nStatus        = 0;
        nXMLSize       = 0;
        
        client         = someClient;
        IP             = client.ip();
        connected      = true;
    } else {
        println("########## not connected ##########");
    }
}

