// connect to server
import java.io.*;
import java.net.*;
import java.net.HttpURLConnection;
import java.net.URL;

// parsing xml
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.*;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PostXML {

	public static void main(String[] args) {

		// parse XML
		Document docXML                = null;
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		String filename                = "./res/test.xml";
		
		try {
			DocumentBuilder builder = factory.newDocumentBuilder();
			docXML = builder.parse(filename);						
		} catch (ParserConfigurationException pe) {			
			System.out.println("ERR:Cannot parse XML(" + pe.getMessage() + ")");
		} catch (SAXException se) {
			System.out.println("ERR:Cannot parse XML(" + se.getMessage() + ")");
		} catch (IOException ie) {
			System.out.println("ERR:Cannot parse XML(" + ie.getMessage() + ")");
		}	
		
		try {
			
			// convert DOM to String
			Source source         = new DOMSource(docXML);
			StreamResult result   = new StreamResult(new StringWriter());

			try {
				Transformer transform = TransformerFactory.newInstance().newTransformer();
				transform.transform(source, result);				
				
			} catch (TransformerConfigurationException e) {				
	        } catch (TransformerException e) {
	        }			

	        String strXML = result.getWriter().toString();
	        
	        // connect to server
	        URL serverURL = new URL("http://localhost/XPMEDIA/xmltest.php");
	        HttpURLConnection http;
									
			http = (HttpURLConnection) serverURL.openConnection();
			http.setRequestMethod("POST");
			http.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
			http.setDoOutput(true);
			
			// post xml
			OutputStreamWriter out = new OutputStreamWriter(http.getOutputStream(), "UTF8");
			out.write(strXML);
			out.close();
			
			// read output
			String decodedString;
			BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));					
				
			while ((decodedString = in.readLine()) != null) {
			    System.out.println(decodedString);
			}

			in.close();
			
		} catch (MalformedURLException e) {
			System.out.println("MalformedURLException: " + e);
	    } catch (IOException e) {
	    	System.out.println("IOException: " + e);
	    }		
	}
}
