
import render.*;

public class test1 extends RenderApplet
{
   Material redPaint, bluePaint;
   Geometry box1, box2;

   public void initialize() {
      setBgColor(.4, .5, .8);
      addLight( 1, 1, 1, .8, .85, 1);
      addLight(-1,-1,-1, 1, 1, 1);

      // TWO DIFFERENT PLASTICS -- ONE RED AND ONE BLUE

      redPaint = new Material();
      redPaint.setAmbient(0.2, 0, 0);
      redPaint.setDiffuse(0.8, 0, 0);
      redPaint.setSpecular(1, 1, 1, 10);

      bluePaint = new Material();
      bluePaint.setAmbient(0, 0, 0.2);
      bluePaint.setDiffuse(0, 0, 0.8);
      bluePaint.setSpecular(1, 1, 1, 10);

      // THE LITTLE BOX IS A CHILD OF THE BIG BOX

      box1 = getWorld().add().cube();
      box1.setMaterial(redPaint);

      box2 = box1.add().cube();
      box2.setMaterial(bluePaint);
   }

   public void animate(double time) {
      Matrix m = box1.getMatrix();

      // BECAUSE WE ARE WOBBLING THE BIG BOX,
      // WE END UP WOBBLING ITS CHILD BOX AS WELL.

      double s = 1 + 0.1 * Math.sin(6 * time);

      m.identity();
      m.scale(s * s, 1 / s, 1 / s);

      m = box2.getMatrix();
      m.identity();
      m.translate(0, 1, 0);
      m.scale(.5, 1, .5);
   }
}

