/*
   This applet is the place where you will
   catch exceptions that are thrown by the
   gesture object.

   You can then define a message to be
   drawn onto the screen using the drawString()
   method, to tell the user what the problem was.
*/

import java.awt.*;

public class GraphMaker extends BufferedApplet
{
   int w = 0, h = 0;
   int xDown = 0, yDown = 0;
   Graph graph = new Graph();
   GraphGesture gesture = new GraphGesture(graph);

   public void render(Graphics g) {
      w = getWidth();
      h = getHeight();

      // MOUSE WENT DOWN

      if (! wasMouseDown && mouseDown) {
         xDown = mouseX;
         yDown = mouseY;
      }

      // MOUSE WENT UP

      if (wasMouseDown && ! mouseDown) {
         gesture.doGesture(xDown, yDown, mouseX, mouseY);
      }

      g.setColor(Color.white);
      g.fillRect(0, 0, w, h);

      graph.draw(g);
   }
}

