/*
   This is the best solution -- we are handling
   the major exceptions (bad arguments) in an
   outer layer that gives up if there are any
   exceptions.

   Nested within that we have an inner layer
   of exception handling for the more subtle
   situation of divide by zero.  In this case
   we can continue the computation even in
   the presence of an exception.
*/

public class arith5
{
   public static void main(String[] args) {
      doIt(args);
   }

   static void doIt(String[] args) {
      int i = 0, j = 0;

      try {
         i = Integer.parseInt(args[0]);
         j = Integer.parseInt(args[1]);

         try {
            System.err.println(i + " / " + j + " = " + (i / j));
         }
         catch (ArithmeticException e) {
            System.err.println("Warning: " + i + " / " + j + " is undefined.");
         }
         System.err.println(i + " * " + j + " = " + (i * j));
         System.err.println(i + " + " + j + " = " + (i + j));
         System.err.println(i + " - " + j + " = " + (i - j));
      }
      catch (ArrayIndexOutOfBoundsException e) {
         System.err.println("usage: java arith3 A B");
      }
      catch (NumberFormatException e) {
         System.err.println("arith3: one or more arguments is not numerical");
      }
   }
}

