/*
   In this example, we catch all three
   types of exceptions in one place.

   The problem with this is that for
   not-so-serious exceptions, such as
   an attempt to divide by zero, the
   rest of the calculations never occur.
*/

public class arith3
{
   public static void main(String[] args) {
      doIt(args);
   }

   static void doIt(String[] args) {
      int i = 0, j = 0;

      try {
         i = Integer.parseInt(args[0]);
         j = Integer.parseInt(args[1]);

         System.err.println(i + " / " + j + " = " + (i / j));
         System.err.println(i + " * " + j + " = " + (i * j));
         System.err.println(i + " + " + j + " = " + (i + j));
         System.err.println(i + " - " + j + " = " + (i - j));
      }
      catch (ArrayIndexOutOfBoundsException e) {
         System.err.println("usage: java arith3 A B");
	 return;
      }
      catch (NumberFormatException e) {
         System.err.println("arith3: one or more arguments is not numerical");
	 return;
      }
      catch (ArithmeticException e) {
         System.err.println("Warning: " + i + " / " + j + " is undefined.");
      }
   }
}

