function [x0,z0] = qcfirst(x,z,blk)
% QCFIRST   computes vectors x0 and z0 of length nblk = length(blk)
%           whose entries consist of the first entries of each
%           block of x and z respectively.
%
%  [x0,z0] = qcfirst(x,z,blk)
%
% input variables:
%     - x            a vector with block structure blk
%     - z            another vector with block structure blk
%     - blk          block info structure
%
% output variables:
%     - x0           vector of length nblk
%     - z0           vector of length nblk

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified : 6/2/97
%
 if isempty(blk) == 0
    nblk = length(blk);
    bidx = zeros(nblk,1);
    bidx(1) = 1;
    for i = 2:nblk
       bidx(i) = bidx(i-1) + blk(i-1);
    end
    x0 = x(bidx);
    z0 = z(bidx);
 else
    fprintf('qcfirst: blk is empty.');
    x0 = [];
    z0 = [];
 end
%
% END function
