function A = brandsym(blk)
% BRANDSYM  builds a block diagonal random symmetric matrix
%           with block structure given by the vector blk
%
% Note:  if sum(blk) == 0 then A is set to 0; this is relevant in
%        mixed conic programs where some type of variables may be absent
%
% A = brandsym(blk)
%
% input variables:
%  - blk          block structure vector
%
% output variables:
%  - A            a symmetric block diagonal matrix

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified: 4/18/97
%
 n = sum(blk);
 if n > 0
    nblk = length(blk);
    if nblk > 1
       A = sparse(n,n);
    else
       A = zeros(n,n);
    end
    start = 1; fin = 0;
    for i = 1:nblk
       bsize = blk(i);
       fin = fin + bsize;
       A(start:fin,start:fin) = randsym(bsize);
       start = start + bsize;
    end
 else
    A = 0;
 end
%
% END function
