function xstep = sdbound(R,dX,blk)
% SDBOUND   computes the stepsize from the positive definite matrix
%           X = R'R to the boundary of the positive definite cone in
%           direction dX
%
% xstep = sdbound(R,dX,blk)
%
%   Thus we need X + alpha dX >= 0.  Let X = R'R, then this is equivalent
%   to
%            alpha (R'\dX)/R >= - I
%   i.e.     (R'\dX)/R  >= -(1/alpha) I
%   i.e.    -eig(R'\dX)/R) <= 1/alpha
%   Therefore set 1/alpha = max of the left-hand side, and take
%   reciprocal. We don't care about negative values (ie positive
%   eigenvalues of (R'\dX)/R). If left hand side < 0, step is AWAY
%   from boundary, so set step = infinity.
%
%   Note: R should be triangular, e.g. the Cholesky factor of X, so
%   that (R'\dX)/R is cheap.
%
% input variables:
%     - R         a factor of X such that X = R'R, e.g. Choleski factor
%     - dX        a block diagonal symmetric matrix, the step
%     - blk       block structure vector
%
% output variables:
%     - xstep     the stepsize

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified: 3/24/97
%
 M = (R'\dX)/R;
 M = 0.5*(M+M');
 eig_M = blkeig(M,blk);
 xstep = 1/max(-eig_M);
 if xstep <= 0,
    xstep = 1.0e10;
 end;
%
% END function
