% NOSFEAS   sets up a block diagonal SDP that does not have a
%           strictly feasible primal point
%
% The following variables must be available in the Matlab workspace:
%    - blk      block structure vector
%    - m        number of constraints

% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97
%
 n2 = (sum(blk .* (blk+1)))/2;
 A = zeros(m,n2);
 n = sum(blk);
 nblk = length(blk);
%
 if nblk > 1,
    randmat = sparse(n,n);
 else
    randmat = zeros(n,n);
 end;
 randmat(1,1) = 1;
 A(1,:) = svec(randmat,blk)';
 for i = 2:m,
    randmat = brandsym(blk);
    A(i,:) = svec(randmat,blk)';
 end;
%
 Ztemp = brandpos(blk);
 ytemp = rand(m,1);
 C = smat(A'*ytemp,blk) + Ztemp;  % constructed so a dual feasible point exists
 Xtemp = brandpos(blk);
 Xtemp(1,1:n) = zeros(1,n);
 Xtemp(1:n,1) = zeros(n,1);
 b = A*svec(Xtemp,blk);   % constructed so a primal feasible point exists
                          % but no strictly feasible primal point can exist
 clear Xtemp ytemp Ztemp  % discard these
