#include "../ske.h"

static const size_t MAGIC = 97;

size_t SKE_K_L() {
    return MAGIC;
}

void ske_enc(const uint8_t *k, bytes_i m, bytes_O c) {
    *c = alloc_bytes(m->l);
    for (size_t i; i < m->l; ++i) {
        c->p[i] = m->p[i] ^ k[i % MAGIC];
    }
}
void ske_dec(const uint8_t *k, bytes_i c, bytes_O m) {
    // ske_enc(k, c, m); // @TODO: unknown bug
    *m = alloc_bytes(c->l);
    for (size_t i; i < c->l; ++i) {
        m->p[i] = c->p[i] ^ k[i % MAGIC];
    }
}
