#include <botan/ffi.h>

#include <string.h>

size_t _SKE_K_L(botan_cipher_t ctx) {
    size_t k_l, _k_l, __k_l;
    assert(botan_cipher_get_keyspec(ctx, &k_l, &_k_l, &__k_l) == 0);
    return k_l;
}

size_t SKE_K_L() {
    botan_cipher_t ctx;
    assert(botan_cipher_init(&ctx, SKE_MODE, 0) == 0);
    size_t k_l = _SKE_K_L(ctx);
    assert(botan_cipher_destroy(ctx) == 0);
    return k_l;
}

void ske_enc(const uint8_t *k, bytes_i m, bytes_O c) {
    botan_cipher_t ctx;
    assert(botan_cipher_init(&ctx, SKE_MODE, BOTAN_CIPHER_INIT_FLAG_ENCRYPT) == 0);
    assert(botan_cipher_set_key(ctx, k, _SKE_K_L(ctx)) == 0);
    size_t iv_l;
    assert(botan_cipher_get_default_nonce_length(ctx, &iv_l) == 0);
    botan_rng_t rng;
    assert(botan_rng_init(&rng, NULL) == 0);
    bytes iv = alloc_bytes(iv_l);
    assert(botan_rng_get(rng, iv.p, iv.l) == 0);
    assert(botan_rng_destroy(rng) == 0);
    assert(botan_cipher_start(ctx, iv.p, iv.l) == 0);
    size_t l;
    assert(botan_cipher_output_length(ctx, m->l, &l) == 0);
    *c = alloc_bytes(iv_l + l); // @TODO: use sparse output
    memcpy(c->p, iv.p, iv_l);
    free_bytes(as_const_bytes(&iv));
    size_t c_l, m_l;
    assert(botan_cipher_update(ctx, BOTAN_CIPHER_UPDATE_FLAG_FINAL, c->p + iv_l, l, &c_l, m->p, m->l, &m_l) == 0);
    assert(c_l == c->l - iv_l);
    assert(m_l == m->l);
    assert(botan_cipher_destroy(ctx) == 0);
}
void ske_dec(const uint8_t *k, bytes_i c, bytes_O m) {
    botan_cipher_t ctx;
    assert(botan_cipher_init(&ctx, SKE_MODE, BOTAN_CIPHER_INIT_FLAG_DECRYPT) == 0);
    assert(botan_cipher_set_key(ctx, k, _SKE_K_L(ctx)) == 0);
    size_t iv_l;
    assert(botan_cipher_get_default_nonce_length(ctx, &iv_l) == 0);
    assert(botan_cipher_start(ctx, c->p, iv_l) == 0);
    size_t l;
    assert(botan_cipher_output_length(ctx, c->l - iv_l, &l) == 0);
    *m = alloc_bytes(l);
    size_t m_l, c_l;
    assert(botan_cipher_update(ctx, BOTAN_CIPHER_UPDATE_FLAG_FINAL, m->p, m->l, &m_l, c->p + iv_l, c->l - iv_l, &c_l) == 0);
    assert(m_l <= m->l); // @Note: padding could exist
    m->l = m_l; // @TODO: [optional] realloc
    assert(c_l == c->l - iv_l);
    assert(botan_cipher_destroy(ctx) == 0);
}
