#include "../prgf.h"

#include "../hkdf.h"

static const_bytes info = {.p = NULL, .l = 0};

void prgf_init(bytes_i seed, bytes_o state) {
    hkdf(seed, &info, &info, state, 1);
}
void prgf_update(bytes_i state, bytes_i input, bytes_o output, bytes_o state_new) {
    bytes outputs[2] = {*state_new, *output};
    hkdf((bytes_i)state, input, &info, outputs, 2);
}
