#ifndef _GENERIC_SIGNAL_CKA_H_
#define _GENERIC_SIGNAL_CKA_H_

#include "bytes.h"

size_t CKA_SEED_N();

void cka_rand_seed(bytes_O seeds);

void cka_init_send(bytes_i seeds, bytes_O k_send);
void cka_init_recv(bytes_i seeds, bytes_O k_recv);

void cka_free_seed(bytes_I seeds);

size_t CKA_CT_N();

void cka_send(uint8_t id, bytes_i k_send, bytes_O cts, bytes_O k, bytes_O k_recv);

void cka_recv(uint8_t id, bytes_i k_recv, bytes_i cts, bytes_O k, bytes_O k_send);

void cka_free_ct(bytes_I cts);

#endif
