#include "../aead.h"

static const size_t MAGIC = 97;

size_t AEAD_K_L() {
    return MAGIC;
}

void aead_enc(const uint8_t *k, bytes_i ads, size_t n_ads, bytes_i m, bytes_O c) {
    size_t l_ads = 0;
    for (size_t n = 0; n < n_ads; ++n) {
        l_ads += ads[n].l;
    }
    size_t l = l_ads + m->l;
    *c = alloc_bytes(l);
    for (size_t n = 0, i = 0; n < n_ads; ++n) {
        for (size_t j = 0; j < ads[n].l; ++j, ++i) {
            c->p[i] = ads[n].p[j];
        }
    }
    for (size_t j = 0, i = l_ads; j < m->l; ++j, ++i) {
        c->p[i] = m->p[j] ^ k[j % MAGIC];
    }
}
int aead_dec(const uint8_t *k, bytes_i ads, size_t n_ads, bytes_i c, bytes_O m) {
    for (size_t n = 0, i = 0; n < n_ads; ++n) {
        for (size_t j = 0; j < ads[n].l; ++j, ++i) {
            if (c->p[i] != ads[n].p[j]) {
                return 1;
            }
        }
    }
    size_t l_ads = 0;
    for (size_t n = 0; n < n_ads; ++n) {
        l_ads += ads[n].l;
    }
    size_t l = c->l - l_ads;
    *m = alloc_bytes(l);
    for (size_t j = 0, i = l_ads; j < m->l; ++j, ++i) {
        m->p[j] = c->p[i] ^ k[j % MAGIC];
    }
    return 0;
}
