# Generic Signal Protocol

## Files

- `README.md`: this file

- `src/`: directory for source codes

    - `src/cka.h`, `src/cka/`: CKA API & implementations

    - `src/prgf.h`, `src/prgf/`: PRGF (PRF-PRG) API & implementations

    - `src/prg.h`, `src/prg/`: PRG API & implementations

    - `src/aead.h`, `src/aead/`: AEAD API & implementations

    - `src/kem.h`, `src/kem/`: KEM API & implementations

    - `src/hkdf.h`, `src/hkdf/`: HKDF API & implementations

    - `src/hmac.h`, `src/hmac/`: HMAC API & implementations

    - `src/prf.h`, `src/prf/`: PRF API & implementations

    - `src/ske.h`, `src/ske/`: SKE API & implementations

    - `src/signal.h`, `src/signal.c`: Signal protocol API & implementation

    - `src/sh.h`, `src/sh.c`: Signal protocol testing shell API & implementation

- `obj/`: directory for compiled modules

- `lib/`: directory for libraries

- `test.c`: testing code

- `makefile`: makefile

- `TODO.md`: todo list

## Build (with `make`)

- `make libs`: download and build (and test) all dependency libraries; libraries can also be installed separately:

    - `make libbotan`: [Botan](https://botan.randombit.net/), cryptographic primitives

        *Note: Botan library costs comparatively long time to build.*

    - `make libfrodo`: [FrodoKEM](https://frodokem.org/), lattice based KEM

        *Note: If AVX2 instructions are not supported, use option `FRODO_GENERIC=1`.*

- `make`, `make all`: build test; `make test`: build and run test; available options:

    - `DEBUG=1`: debug mode

    - `FRODO_GENERIC=1`: generic mode implementation of FrodoKEM library (use this option when the FrodoKEM library is built with the same option)

    - `CKA=...`: CKA option; available:
        - `dh25519c`
        - `frodo640c` (default)
        - `frodo976c`
        - `frodo1344c`
        - `kem`

    - `PRGF=...`: PRGF option; available:
        - `hkdf` (default)
        - `insecure` (insecure implementation for testing)

    - `PRG=...`: PRG option; available:
        - `prf` (default)
        - `insecure` (insecure implementation for testing)

    - `AEAD=...`: AEAD option; available:
        - `aes128siv` (default)
        - `aes192siv`
        - `aes256siv`
        - `ske-hmac`
        - `insecure` (insecure implementation for testing)

    - `KEM=...`: KEM option, only effective when `CKA=kem`; available:
        - `dh25519` (temporarily broken due to library incompatibility)
        - `dh25519s` (not implemented)
        - `frodo640` (default)
        - `frodo976`
        - `frodo1344`
        - `frodo640s`
        - `frodo976s`
        - `frodo1344s`

    - `HKDF=...`: HKDF option, only effective when `PRGF=hkdf`; available:
        - `sha256` (default)
        - `sha512`
        - `hmac`

    - `HMAC=...`: HMAC option, only effective when [`PRGF=hkdf` and `HKDF=hmac`] or `AEAD=ske-hmac`; available:
        - `sha256` (default)
        - `sha512`

    - `PRF=...`: PRF option, only effective when `PRG=prf`; available:
        - `sha256` (default)
        - `sha512`

    - `SKE=...`: SKE option, only effective when `AEAD=ske-hmac`; available:
        - `aes128cbc` (default)
        - `aes192cbc`
        - `aes256cbc`
        - `insecure` (insecure implementation for testing)

- `make clean`: remove `obj/`

- `make distclean`: remove `obj/` and `lib/`
