#include "src/sh.h"
#include <time.h>

#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <execinfo.h>
void handler(int sig) {
    void *array[10];
    size_t size;
    size = backtrace(array, 10);
    fprintf(stderr, "Error: signal %d.\n", sig);
    backtrace_symbols_fd(array, size, STDERR_FILENO);
    exit(sig);
}

int main() {
    signal(SIGABRT, handler);
    signal(SIGSEGV, handler);

    init();

    size_t s = send(A, "initial message from A to B: hello world");
    recv(s);

    srand(time(NULL));

    const size_t MAX_N = 9999;
    const size_t MAX_L = 9999;

    size_t send_id[MAX_N];
    size_t send_n = 0;
    uint8_t recv_flag[MAX_N];
    for (size_t i = 0; i < MAX_N; ++i) {
        recv_flag[i] = 0;
    }
    size_t recv_n = 0;

    char m[MAX_L];
    for (size_t i = 0; i < MAX_N; ++i) {
        int send_flag = rand() % 3;
        if (send_flag < 2) {
            size_t l = rand() % MAX_L + 1;
            for (size_t i = 0; i < l; ++i) {
                // m[i] = rand() % (127 - 32) + 32; // ASCII visible
                do {
                    m[i] = rand();
                } while (m[i] == 0);
            }
            m[l] = 0;
            send_id[send_n++] = send(send_flag, m);
        } else {
            if (recv_n == send_n) {
                continue;
            }
            ++recv_n;
            while (1) {
                size_t s = rand() % send_n;
                if (recv_flag[s]) {
                    continue;
                }
                recv(send_id[s]);
                recv_flag[s] = 1;
                break;
            }
        }
    }
    while (recv_n < send_n * 0.9) {
        ++recv_n;
        while (1) {
            size_t s = rand() % send_n;
            if (recv_flag[s]) {
                continue;
            }
            recv(send_id[s]);
            recv_flag[s] = 1;
            break;
        }
    }
    for (size_t s = send_n-1; ; --s) {
        if (recv_flag[s]) {
            if (s == 0) {
                break;
            }
            continue;
        }
        recv(send_id[s]);
        // recv_flag[s] = 1;
        if (s == 0) {
            break;
        }
    }

    free_all();

    return 0;
}
