#include "../prg.h"

#include "../prf.h"

#include <string.h>

void prg(bytes_i seed, bytes_o outputs, size_t n_outputs) {
    bytes output = alloc_bytes(PRF_OUTPUT_L());
    uint8_t index = 0;
    const_bytes input = {.p = &index, .l = 1};
    for (size_t i = 0; i < n_outputs; ++i) {
        size_t l = 0;
        while (l < outputs[i].l) {
            if (index == 0 && (i > 0 || l > 0)) { // overflow
                assert(0);
            }
            prf(seed, &input, output.p);
            ++index;
            if (l + output.l <= outputs[i].l) {
                memcpy(outputs[i].p + l, output.p, output.l);
                l += output.l;
            } else {
                memcpy(outputs[i].p + l, output.p, outputs[i].l - l);
                l = outputs[i].l;
            }
        }
    }
    free_bytes(as_const_bytes(&output));
}
