#include "../_frodo_patch.c"
#include "../_frodo_patch_0.c"

size_t KEM_PK_L() {
    return CRYPTO_PUBLICKEYBYTES;
}
size_t KEM_SK_L() {
    return CRYPTO_SECRETKEYBYTES;
}
size_t KEM_CT_L() {
    return (PARAMS_LOGQ*PARAMS_N*PARAMS_NBAR)/8 + (PARAMS_NBAR*PARAMS_NBAR)/8;
}
size_t KEM_K_L() {
    return BYTES_MU;
}

void kem_gen(uint8_t *pk, uint8_t *sk) {
    frodo_gen(pk, sk);
}
void kem_enc(const uint8_t *pk, uint8_t *ct, uint8_t *k) {
    frodo_enc(NULL, k, ct, pk);
}
void kem_dec(const uint8_t *sk, const uint8_t *ct, uint8_t *k) {
    frodo_dec(NULL, k, ct, sk);
}
