#ifndef _GENERIC_SIGNAL_TYPE_BYTES_H_
#define _GENERIC_SIGNAL_TYPE_BYTES_H_

#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <assert.h>

typedef struct _bytes {
    uint8_t *p;
    size_t l;
} bytes;
typedef struct _const_bytes {
    const uint8_t *p;
    size_t l;
} const_bytes;

/*\
|*| bytes * == uint8_t *: as dynamic output (to be allocated)
|*| const_bytes * == const uint8_t *: as dynamic input (to be freed)
|*| const bytes * == uint8_t * const: as output
|*| const const_bytes * == const uint8_t * const: as input
\*/
typedef bytes *bytes_O;
typedef const_bytes *bytes_I;
typedef const bytes *bytes_o;
typedef const const_bytes *bytes_i;

static inline bytes alloc_bytes(size_t l) {
    bytes b = {.p = malloc(l), .l = l};
    assert(b.p != NULL);
    return b;
}
static inline bytes copy_bytes(bytes_i bp) {
    bytes b = alloc_bytes(bp->l);
    memcpy(b.p, bp->p, bp->l);
    return b;
}
static inline void free_bytes(bytes_I bp) {
    assert(bp->p != NULL);
    free((void *)bp->p);
    bp->p = NULL;
    // bp->l = 0;
}

static inline const_bytes to_const_bytes(bytes b) {
    const_bytes cb = {.p = (const uint8_t *)b.p, .l = b.l};
    return cb;
}
static inline const_bytes *as_const_bytes(bytes *bp) {
    return (const_bytes *)bp;
}

static inline bytes __WARN__to_bytes(const_bytes cb) {
    bytes b = {.p = (uint8_t *)cb.p, .l = cb.l};
    return b;
}
static inline bytes *__WARN__as_bytes(const_bytes *cbp) {
    return (bytes *)cbp;
}

#ifdef DEBUG
#include <stdio.h>
static inline void print_byte(bytes_i bp) {
    static const char hex[] = "0123456789ABCDEF";
    const char *suffix = " = ";
    size_t l = bp->l;
    if (l > 32) {
        l = 32;
        suffix = "...";
    }
    for (size_t i = 0; i < l; ++i) {
        printf("%c%c", hex[bp->p[i] / 16], hex[bp->p[i] % 16]);
    }
    printf("%s[%zd]\n", suffix, bp->l);
}
#endif

#endif
