function [spikeLocs,spikeVals,dualvar] = tvMin(K, sampLocs, sampVals, spikeMesh)
%Recovers the location and weights on the spikes given sample data and a
%spike mesh using discrete total variation (i.e., L1) minimization.
%K : Kernel function
%sampLocs: shape = [1,n_samps], vector of sample locations
%sampVals: shape = [1,n_samps], vector of sample values
%spikeMesh: fine grid of locations on which spikes may lie
    sampVals = sampVals';
    D = makeDict(spikeMesh,sampLocs,K);
    cvx_begin quiet
    cvx_precision high
    dual variable dv;
    variable x_esti(length(spikeMesh),1);
    minimize(norm(x_esti,1))
    subject to
        dv: D*x_esti==sampVals
    cvx_end
    dualvar = dv';
    spikeLocs = spikeMesh(abs(x_esti) > 1e-6);
    spikeVals = x_esti(abs(x_esti) > 1e-6)';
end