% TV solver with l2 norm regularization,
% uses TFOCS (http://tfocs.stanford.edu/)
%
% Author: Carlos Fernandez-Granda 
% Email: cfgranda@stanford.edu
function varargout = solver_TV_L2( A, b,lambda, mu, x0, z0,n1,n2, opts, varargin )


% -- legacy options from original software --
if isfield(opts,'lambda0')
    opts = rmfield(opts,'lambda0');
end
if isfield(opts,'xPlug')
    opts = rmfield(opts,'xPlug');
end
if isfield(opts,'solver')
    svr     = opts.solver;
    opts    = rmfield(opts,'solver');
    if isfield(opts,'alg') && ~isempty(opts.alg)
        disp('Warning: conflictiong options for the algorithm');
    else
        % if specified as "solver_AT", truncate:
        s = strfind( svr, '_' );
        if ~isempty(s), svr = svr(s+1:end); end
        opts.alg = svr;
    end
end


nonneg = false;
if isfield(opts,'nonneg')
    nonneg  = opts.nonneg;
    opts = rmfield(opts,'nonneg');
end
if isfield(opts,'nonNeg')
    nonneg  = opts.nonNeg;
    opts = rmfield(opts,'nonNeg');
end

if nonneg       
    % -- case: x >= 0 constraints
    prox    = proj_Rplus;
else
    % -- case: no x >= 0 constraint
    prox    = [];
end

W   = linop_TV( [n1,n2] );

normW           = linop_TV( [n1,n2], [], 'norm' );

normA = linop_normest( A ).^2;
proxScale   = sqrt( normW / normA );
prox_2        = { smooth_quad, proj_linf(proxScale* lambda ) };
W = linop_compose( W, 1 / proxScale );

[varargout{1:max(nargout,1)}] = ...
    tfocs_SCD( prox, { A, -b; W, 0 }, prox_2, mu, x0, z0, opts, varargin{:} );
    

% TFOCS v1.1 by Stephen Becker, Emmanuel Candes, and Michael Grant.
% Copyright 2012 California Institute of Technology and CVX Research.
% See the file TFOCS/license.{txt,pdf} for full license information.

