rand('seed', 100000);
randn('seed', 100000);
data = dlmread('2008.data.prep');
[m, n] = size(data)
p = randperm(m);
data = data(p(1:m), :);
feature = [data(:,1:7) data(:,9:end)]; % take fea-9 as the target
y = data(:, 8)<0; % 0-1
feature = bsxfun(@minus, feature, mean(feature));

stdfea = std(feature);
stdfea(stdfea <= 0.00001) = 1;
feature = bsxfun(@rdivide, feature, stdfea);

data = [feature, y];
cvo = cvpartition(m, 'k', 59);
save airline.mat data cvo
