function x = toepsolve(c,r,y)

% Solve y = T*x of y of size (n,k) with T = toeplitz(c,r) of size (n,n) using
% Levinson recursion.
%
% Needs O(4*n^2*k) time and O(n*k) space.
%
% Copyright (c) by Hannes Nickisch, 2014-12-09.

if isempty(r), r = c; end
r = r(:); c = c(:);                                        % make column vectors
[n,k] = size(y);
f = ones(1,k)/c(1); b = ones(1,k)/c(1);      % init forward and backward vectors
x = y(1,:)/c(1);                                                   % init result
for i=2:n
  ex = c(i:-1:2)'*x; ef = c(i:-1:2)'*f; eb = r(2:i)'*b;    % compute error terms
  f0 = [f;zeros(1,k)]; b0 = [zeros(1,k);b];
  oi = ones(i,1); w = oi*(1-eb.*ef);
  f = (f0 - (oi*ef).*b0)./w;
  b = (b0 - (oi*eb).*f0)./w;
  x = [x;zeros(1,k)] + (oi*(y(i,:)-ex)).*b;
end