function [logdetT,v] = toeplogdet(r)

% Modified Durbin for logdet(T) with T = toeplitz(r) of size (n,n).
% Zhang et al., Time-series GPR Based on Toeplitz Computation, 2005, algs 1.2/3
%
% Needs O(n^2) time and O(n) space.
%
% Copyright (c) by Hannes Nickisch, 2014-12-09.

n = numel(r); r = r(:);
s = r(2:n)/r(1);
m = numel(s); s = s(:);
z = zeros(m,1);
z(1) = -s(1); b = 1; a = -s(1); l = 0;
for i=1:m-1
  b = (1-a*a)*b;
  l = l + log(b);
  a = -(s(i+1)+s(i:-1:1)'*z(1:i))/b;
  z(1:i) = z(1:i) + a*z(i:-1:1);
  z(i+1) = a;
end
logdetT = l + log((1-a*a)*b) + n*log(r(1));
if nargout>1
  v = zeros(n,1); v(n) = 1/(r(1)*(1+s'*z)); v(1:n-1) = v(n)*z(n-1:-1:1);
end