clear all, close all
dev = @(x,y) max(abs(x(:)-y(:)))/max([max(abs(x(:))),max(abs(y(:))),1]);

N = 200;

ell = N/50;  % approximation breaks down as ell increases
% z = covSEiso(log([ell,1.2]'),(1:N)',1);
% z = 2;             % OK
% z = [2,-1];        % OK
% z = [4,2];         % OK
z = [8,-5,1];      % OK
% z = [8,3,1];
% z = [12,5,0,1];    % OK
% z = [34,-21,8,-4]; % OK
% z = [34,-21,8,-4,2,-1];
c = zeros(N,1); c(1:numel(z)) = z;

K = toeplitz(c);
tic, [V,D] = eig(K); d = max(real(diag(D)),0); V = real(V);         % K = V*D*V'
[d,ord] = sort(d); V = V(:,ord); td = toc;
tic, [e,W] = toepeig(K(:,1),1e-8);
[e,ord] = sort(e); W = W(:,ord);
te = toc;
tic; [f,Q] = teig(c); tf = toc;

sn = 1e-3; K = K+sn^2*eye(N); e = e+sn^2; d = d+sn^2;                % add noise

tr = trace(K);                                          % trace is very accurate
assert(dev(sum(d),tr)<1e-10)
ld = 2*sum(log(diag(chol(K))));               % log determinant is less accurate
assert(dev(sum(log(d)),ld)<1e-6)

[sum(log(e)),ld, sum(e),tr]

subplot(121)
 loglog(d,e,'o'), xlabel('ex/eig'), ylabel('apx/toepeig'), grid on, hold on
 plot([min(d),max(d)],[min(d),max(d)],'k')

subplot(122)
 dK = K-W*diag(e)*W'; % d/e
 imagesc(abs(dK)/max(abs(K(:)))), colorbar

fprintf('speedup factor %1.2f\n',td/te)
fprintf('eigenvalue deviation %1.3e\n',dev(d,e))
fprintf('eigendecomp deviation %1.3e\n',norm(dK,1)/norm(K,1))

 ep = abs(c(1))/1e3;
 id = find(abs(c)>ep,1,'last');
 A = dK(1:id-2,1:id-2); B = hankel(c(3:id));