clear all, close all

if 1                                           % just compile of perform testing
  mex toeplogdet.c
  mex toepsolve.c
  mex toepsumdiaginv.c
  return
end

addpath ../../toeblitz
run ../../toeblitz/startup

N = 2500;                                                           % toeplogdet
if 1
  fprintf('toeplogdet\n')
  c = exp(-linspace(0,10,N).^2); c(1) = c(1) + 1e-6;
  tic, [ld_mat,v_mat] = toeplogdet(c); t_mat = toc;
  if N<2600
    tic, ld_cho = 2*sum(log(diag(chol(toeplitz(c))))); t_cho = toc;
  else
    ld_cho = ld_mat; t_cho = 0;
  end
  tic, ld_tbl = logdetToeplitz(c,1); t_tbl = toc;
  mex toeplogdet.c
  tic, [ld_mex,v_mex] = toeplogdet(c); t_mex = toc;
  delete toeplogdet.mex*
  dev = @(x,y) max(abs(x(:)-y(:)))/max([max(abs(x(:))),max(abs(y(:))),1]);
  err = [dev(ld_mat,ld_cho), dev(ld_mex,ld_cho), dev(ld_tbl,ld_cho)];
  if max(err)>1e-8, error('toeplogdet error'), end
  if dev(v_mat,v_mex)>1e-8, error('v error'), end
  fprintf('  runtime relative to mex %1.3fs\n',t_mex)
  fprintf('    chol, matlab, toeblitz\n')
  fprintf('  %1.4f, %1.4f, %1.4f\n',[t_cho, t_mat, t_tbl]/t_mex)
end

N = 2500; k = 20;
if 1
  fprintf('toepsolve\n')
  c = exp(-linspace(0,10,N).^2); c(1) = c(1) + 1e-6;
  y = randn(N,k);
  tic, x_mat = toepsolve(c,[],y); t_mat = toc;
  warning off all                    % supress toeplitz row/col conflict warning
  if N<2600
    tic, x_bsl = toeplitz(c)\y; t_bsl = toc;
  else
    x_bsl = x_mat; t_bsl = 0;
  end
  warning on all
  tic
    x_tbl = zeros(size(y));
    for i=1:k, x_tbl(:,i) = solveToeplitz(c(:)',y(:,i),'LD'); end
  t_tbl = toc;
  mex toepsolve.c
  tic, x_mex = toepsolve(c,[],y); t_mex = toc;
  delete toepsolve.mex*
  dev = @(x,y) max(abs(x(:)-y(:)))/max([max(abs(x(:))),max(abs(y(:))),1]);
  err = [dev(x_mat,x_bsl), dev(x_mex,x_bsl), dev(x_tbl,x_bsl)];
  if max(err)>5e-5, error('toepsolve error'), end
  fprintf('  runtime relative to mex %1.3fs\n',t_mex)
  fprintf('  backsl, matlab, toeblitz\n')
  fprintf('  %1.4f, %1.4f, %1.4f\n',[t_bsl, t_mat, t_tbl]/t_mex)
end

N = 2500;
if 1
  fprintf('toepsumdiaginv\n')
  c = exp(-linspace(0,10,N).^2); c(1) = c(1) + 1e-3;
  [ld,v] = toeplogdet(c);
  tic, s_mat = toepsumdiaginv(v); t_mat = toc;
  if N<2600
    tic, s_sum = zeros(N,1); iK = inv(toeplitz(c));
    for i=1:N, s_sum(i) = sum(diag(iK,i-1)); end
    t_sum = toc;
  else
    ld_sum = ld_mat; t_sum = 0;
  end
  mex toepsumdiaginv.c
  tic, s_mex = toepsumdiaginv(v); t_mex = toc;
  delete toepsumdiaginv.mex*
  dev = @(x,y) max(abs(x(:)-y(:)))/max([max(abs(x(:))),max(abs(y(:))),1]);
  err = [dev(s_mat,s_sum), dev(s_mex,s_sum)];
  if max(err)>1e-8, error('toepsumdiaginv error'), end
  fprintf('  runtime relative to mex %1.3fs\n',t_mex)
  fprintf('     sum, matlab\n')
  fprintf('  %1.4f, %1.4f\n',[t_sum, t_mat]/t_mex)
end