clear all, close all, seed = 4; randn('seed',seed); rand('seed',seed)
dev = @(x,y) max(abs(x(:)-y(:)))/max([max(abs(x(:))),max(abs(y(:))),1]);

cov = {@covSEiso};
sf = 1; ell = 0.5; hyp.cov = log([ell;sf]);
mean = {@meanLinear}; hyp.mean = 0.2;
lik = @likGauss; hyp.lik = log(0.1);
x = linspace(0,10,1200)';
y = sin(0.6*x).^2 + randn(size(x))/10;

[post nlZ dnlZ] = infExact(hyp, mean, cov, lik, x, y);
addpath ../toepgrid
[postg nlZg dnlZg] = infToep(hyp, mean, cov, lik, x, y);
rmpath ../toepgrid

max([dev(post.alpha,postg.alpha),
     dev(dnlZ.cov,dnlZg.cov),
     dev(dnlZ.mean,dnlZg.mean),
     dev(dnlZ.lik,dnlZg.lik),
     dev(nlZ,nlZg)])

plot(x,y,'+')