clear all, close all, seed = 4; randn('seed',seed); rand('seed',seed)
dev = @(x,y) max(abs(x(:)-y(:)))/max([max(abs(x(:))),max(abs(y(:))),1]);

addpath toepgrid                                       % toep*, infGrid, covGrid

opt.cg_maxit = 500; opt.cg_tol = 1e-6; opt.stat = false; % keep the values fixed
for cs = 1:3                                         % toggle between test cases
  if cs==1
    nx = [70,4,3]; Dx = [1,2,3]; xg = cell(numel(nx),1); % grid data generation
    for i=1:numel(nx), xg{i} = randn(nx(i),Dx(i)); end
    x = covGrid('expand',xg);                                        % full data
    cov = {{@covSEard},{@covRQard},{@covSEiso}};
    hyp.cov = rand(eval(covGrid(cov,xg)),1);
    y = x(:,1).^2 + x(:,2) - log(abs(x(:,3)));
    s = '6d Kron [1,2,3]';
  elseif cs==2
    nx = [37,28]; Dx = [1,1]; xg = {linspace(0,2,nx(1))',linspace(0,2,nx(2))'};
    [x2,x1] = meshgrid(xg{2},xg{1});
    x = [x1(:),x2(:)]; clear x1 x2
    cov = {{@covSEiso},{@covSEiso}};
    sf = 1; ell = 1; hyp.cov = log([ell;sf;ell;sf]);
    y = x(:,1).^2 + x(:,2);
    s = '2d block-Toep';
  else
    nx = 1102; Dx = 1; x = linspace(0,2,nx)';
    xg = {{x}};
    x = x+0.2*(x(2)-x(1));
    cov = {@covSEiso};
    sf = 1; ell = 0.5; hyp.cov = log([ell;sf]);
    y = x.^2 + x;
    s = '1d Toep';
  end
  N = prod(nx);
  fprintf('Case %d (%s) N=%d\n',cs,s,N)
  
  mean = {@meanLinear}; hyp.mean = 0.2*ones(sum(Dx),1);
  z = randn(56,sum(Dx)); zi = randi(N,56,1);
  sn = 0.3;  hyp.lik = log(sn);
  cv = cell(size(cov));                 % full covariance via pointwise products
  for i=1:numel(cv), cv{i} = {@covMask,{sum(Dx(1:i-1))+(1:Dx(i)),cov{i}}}; end
  cv = {@covProd,cv};
  idz = (1:3:N)';                                   % incomplete prediction grid

  for dn=1:2
    fprintf(' data stride dn=%d\n',dn)
    idx = (1:dn:N)'; yi = y(idx);
    tic
      [nlZ dnlZ post]   = gp(hyp, [], mean, cv, [], x(idx,:), yi);
      [ymu ys2 fmu fs2] = gp(hyp, [], mean, cv, [], x(idx,:), yi, x(idz,:));
    fprintf('   dense inf/pred took %3.1fs\n',toc)
    covg = {@covGrid,cov,xg};
    tic
      [postg nlZg dnlZg] = infGrid(hyp,mean,covg,'likGauss',idx,yi,opt);
      [ymug ys2g fmug fs2g] = gp(hyp,@infGrid,mean,covg,[],idx,postg,idz);%index
    fprintf('   grid  inf/pred took %3.1fs\n',toc)
    xe = covGrid('expand',xg);
    [ymugz ys2gz] = gp(hyp,@infGrid,mean,covg,[],idx,postg,xe(idz,:));   % dense
    if cs>1                                       % fast interpolated prediction
      ymug2 = postg.predict(idz);
      ymug3 = postg.predict(xe(idz,:));
      assert(norm(ymug2-ymug)+norm(ymug3-ymug)<1e-12)
    end
    assert(dev(ymug,ymugz)+dev(ys2g,ys2gz)<1e-14)     % dense should equal index

    err_inf = [dev(postg.alpha,post.alpha),dev(postg.sW,post.sW)];
    err_prd = [dev(ymu,ymug), dev(ys2,ys2g), dev(fmu,fmug), dev(fs2,fs2g)];
    err_nlZ = dev(nlZ,nlZg); err_dlZ = dev(unwrap(dnlZ),unwrap(dnlZg));
    err = [max(err_inf), max(err_prd), err_nlZ, err_dlZ];

    fprintf('   inf/prd = %1.2e/%1.2e\n',err(1:2))
    fprintf('   nlZ/dlZ = %1.2e/%1.2e\n',err(3:4))
  end
end

% regression test
% test_infGrid
% Case 1 (6d Kron [1,2,3]) N=840
%  data stride dn=1
%    dense inf/pred took 3.5s
%    grid  inf/pred took 0.4s
%    inf/prd = 2.03e-12/2.42e-13
%    nlZ/dlZ = 4.13e-11/3.71e-11
%  data stride dn=2
%    dense inf/pred took 0.8s
%    grid  inf/pred took 11.9s
%    inf/prd = 2.41e-05/2.17e-05
%    nlZ/dlZ = 1.94e-02/8.93e-03
% Case 2 (2d block-Toep) N=1036
%  data stride dn=1
%    dense inf/pred took 2.9s
%    grid  inf/pred took 0.2s
%    inf/prd = 9.08e-07/5.88e-15
%    nlZ/dlZ = 2.89e-13/9.29e-14
%  data stride dn=2
%    dense inf/pred took 0.6s
%    grid  inf/pred took 2.7s
%    inf/prd = 5.35e-06/8.66e-07
%    nlZ/dlZ = 5.61e-06/1.45e-06
% Case 3 (1d Toep) N=1102
%  data stride dn=1
%    dense inf/pred took 2.6s
%    grid  inf/pred took 9.2s
%    inf/prd = 5.47e-06/6.23e-07
%    nlZ/dlZ = 1.40e-02/1.81e-03
%  data stride dn=2
%    dense inf/pred took 0.7s
%    grid  inf/pred took 8.1s
%    inf/prd = 7.97e-06/7.57e-07
%    nlZ/dlZ = 2.63e-02/3.23e-03