dim = [5:10]; % dimensions to test for full space
n_rep = 5; % number of repetitions per dimensionality
nd = length(dim);

dis = zeros(nd, 1);
smae_fast = zeros(nd, 1);
smae_slow = zeros(nd, 1);
smae_full = zeros(nd, 1);
smae_sub  = zeros(nd, 1);


for i=1:nd

    D = dim(i);

    res = norm_avg_proj_gauss(n_rep, D, 2, 2, 200, 100, 50);
    smae_fast(i) = res.smae_fast;
    smae_slow(i) = res.smae_slow;
    smae_full(i) = res.smae_full;
    smae_sub(i) = res.smae_sub;
    dis(i) = res.dis;
end
figure();
plot(dim, dis);
xlabel('Number of Dimensions');
ylabel('Distance of Projected Spaces');
title('2d data in D dimensions');       
xlabel('Number of Dimensions D');

figure();
plot(dim, smae_fast);
hold on;
plot(dim, smae_slow);
plot(dim, smae_full);
plot(dim, smae_sub);
xlabel('Number of Dimensions');
ylabel('Average SMAE');
title('2d data in D dimensions');       
xlabel('Number of Dimensions D');
legend('Fast Pred', 'Slow Pred', 'Full-dim GP', 'true sub GP')
