clear all, close all
dev = @(x,y) max(abs(x(:)-y(:)))/max([max(abs(x(:))),max(abs(y(:))),1]);

addpath ../../../test/toepgrid                                % infGrid, covGrid

n = 30; ng = [40,30]; ns = [420,320]; nu = 150;
opt.cg_maxit = 500; opt.cg_tol = 1e-4;                 % keep these values fixed
opt.pred_var = 20;                   % number of samples for pred var estimation

cov = {@covSEiso};
sf = 1.2; ell = 0.5; hyp.cov = log([ell;sf]);
x = 8*rand(n,2)-4;
y = cos(4*x(:,1)).*sin(3*x(:,2)) + randn(n,1)/20;
mean = {@meanLinear}; hyp.mean = [0.2;0.1];
lik = @likGauss; sn = 0.3;  hyp.lik = log(sn);

xs1 = linspace(-4,4,ns(1)); xs2 = linspace(-4,4,ns(2));
[x2,x1] = meshgrid(xs2,xs1);
xs = [x1(:),x2(:)]; clear x1 x2
xg = {linspace(-5,5,ng(1))',linspace(-5,5,ng(2))'};
[x2g,x1g] = meshgrid(xg{2},xg{1});
covg = {@covGrid,{cov,cov},xg};
hypg = hyp; hypg.cov = log([ell;sqrt(sf);ell;sqrt(sf)]);
[postg nlZg dnlZg] = infGrid(hypg,mean,covg,lik,x,y,opt);
[fmug fs2g ymug ys2g] = postg.predict(xs);
xu = 8*rand(nu,2)-4; covf = {@covFITC,cov,xu};
[postf nlZf dnlZf] = infFITC(hyp,mean,covf,lik,x,y);
[ymuf ys2f] = gp(hyp,@infFITC,mean,covf,lik,x,postf,xs);

if n<=1e3
  tic
  [nlZ dnlZ post] = gp(hyp,@infExact,mean,cov,lik,x,y);
  [ymu ys2] = gp(hyp,@infExact,mean,cov,lik,x,post,xs);
  t = toc;
  subplot(231), imagesc(xs1,xs2,reshape(ymug,ns)',[-1,1]), title('ym-grid')
  hold on, plot(x(:,1),x(:,2),'w*'), plot(x1g(:),x2g(:),'b+')
  subplot(232), imagesc(xs1,xs2,reshape(ymu, ns)',[-1,1]), title('ym-exact')
  hold on, plot(x(:,1),x(:,2),'w*')
  subplot(233), imagesc(xs1,xs2,reshape(ymuf,ns)',[-1,1]), title('ym-fitc')
  hold on, plot(x(:,1),x(:,2),'w*'), plot(xu(:,1),xu(:,2),'r+')
  subplot(234), imagesc(xs1,xs2,reshape(sqrt(ys2g),ns)',[sn,sf+sn]), title('ys-grid')
  hold on, plot(x(:,1),x(:,2),'w*'), plot(x1g(:),x2g(:),'b+')
  subplot(235), imagesc(xs1,xs2,reshape(sqrt(ys2),ns)',[sn,sf+sn]), title('ys-exact')
  hold on, plot(x(:,1),x(:,2),'w*')
  subplot(236), imagesc(xs1,xs2,reshape(sqrt(ys2f),ns)',[sn,sf+sn]), title('ys-fitc')
  hold on, plot(x(:,1),x(:,2),'w*'), plot(xu(:,1),xu(:,2),'r+')
end