function s = toepsumdiaginv(v)

% Compute s of size (n,1) with s(i) = sum(diag(inv(T),i-1)), where
% T = toeplitz(r) of size (n,n) using Trench's algorithm.
% The input v is obtained by the call [ld,v] = toeplogdet(r).
% Zhang et al., Time-series GPR Based on Toeplitz Computation, 2005, alg 3.1
%
% Needs O(13*n^2/4) time and O(n) space.
%
% Copyright (c) by Hannes Nickisch, 2014-12-09.

n = numel(v); s = zeros(n,1);
for k=1:n                              % iterate over diagonals diag(inv(T),k-1)
  for j=1:floor((n-k)/2)+1
    i = j+k-1;
    if j==1
      w = v(n+1-i);
    else
      w = w + (v(n+1-j)*v(n+1-i)-v(i-1)*v(j-1))/v(n);
    end                               % double summation except for antidiagonal
    s(k) = s(k) + (2-(i==n-j+1))*w;
  end
end