function b = toepmvmsym(c,x,pad2)

% Perform MVM b = T*x of x of size (n,m) with T = toeplitz(c) of size (n,n)
% by convolution in the Fourier domain. All variables are assumed real valued.
% The flag pad2 indicates whether a padding of the data to the next power
% of 2 is desired.
%
% Needs O(3*m*n*log(n)) time and O(n*m) space.
%
% Copyright (c) by Hannes Nickisch, 2014-12-09.

persistent cold f
[n,m] = size(x); c = c(:);       % extract dimensions and make c a column vector
if nargin>2 && pad2                          % decide whether padding is desired
  nf = 2^ceil(log2(n)+1);
else
  nf = 2*n-1;
end
if numel(cold)~=numel(c) || max(abs(cold(:)-c(:)))>1e-10 || numel(f)~=nf
  f = fft([c; zeros(nf-2*n+1,1); flipud(c(2:n))]); cold = c;
end
b = fft(x,nf);
if exist('bsxfun','builtin')              % use fast multiplication if available
  b = bsxfun(@times,f,b);
else
  b = repmat(f,1,m).*b;
end
b = ifft(b);
b = real(b(1:n,:));                  % only keep the relevant part of the result
