/* Modified Durbin for logdet(T) with T = toeplitz(r) of size (n,n).
 * Zhang et al., Time-series GPR Based on Toeplitz Computation, 2005, algs 1.2/3
 * Needs O(n^2) time and O(n) space. 
 *
 * Copyright (c) by Hannes Nickisch, 2014-12-08.                              */
#include <math.h>
#include <mex.h>

#define	 R_IN	  prhs[0]
#define	LD_OUT	plhs[0]
#define	 V_OUT	plhs[1]

void mexFunction( int nlhs, mxArray *plhs[], int nrhs, const mxArray*prhs[] )
{
  double *ld, *r, *v, *z, *s, *t, a, b, l;                         /* declare */
	int i,j,n;

	if      (nrhs != 1) mexErrMsgTxt("One input argument required.");  /* check */
	else if (nlhs >  2) mexErrMsgTxt("At most two output arguments available."); 

  n = mxGetNumberOfElements(R_IN);  r  = mxGetPr(R_IN);             /* assign */
  LD_OUT = mxCreateDoubleScalar(0); ld = mxGetPr(LD_OUT);

  s = (double*) mxMalloc((n-1)*sizeof(double));                   /* allocate */
  z = (double*) mxMalloc((n-1)*sizeof(double));
  t = (double*) mxMalloc((n-1)*sizeof(double));

  for (i=0; i<n-1; i++) s[i] = r[i+1]/r[0];                           /* init */
  z[0] = -s[0]; b = 1.0; a = -s[0]; l = 0.0;
  
  for (i=0; i<n-2; i++) {                                          /* compute */
    b = (1-a*a)*b; l += log(b);
    a = 0; for (j=0; j<i+1; j++) a += s[i-j]*z[j];
    a = -(s[i+1] + a)/b;
    for (j=0; j<i+1; j++) t[j] = z[j];
    for (j=0; j<i+1; j++) z[j] += a*t[i-j];
    z[i+1] = a;
  }
  ld[0] = l + log((1-a*a)*b)+ n*log(r[0]);
  
  if (nlhs>1) {
    V_OUT = mxCreateDoubleMatrix(n,1,mxREAL); v = mxGetPr(V_OUT);
    a = 0; for (j=0; j<n; j++) a += s[j]*z[j];
    v[n-1] = 1/(r[0]*(1+a));
    for (i=0; i<n-1; i++) v[i] = v[n-1]*z[n-2-i];
  }

  mxFree(s); mxFree(z); mxFree(t);                                 /* tidy up */
}