function hyp = proj_ell_init(num_inits, num_steps, hypin, opt, varargin)

[d D] = size(hypin.P);
nlml_best = gp(hypin, varargin{:});
hyp = hypin;
X = varargin{end-1};
for i=1:num_inits
   
    Ptest = randn(d,D);
    hyptest = hypin;
    hyptest.P = Ptest;

    P = hyptest.P;
    if opt.proj_ortho
       P = sqrtm(P*P')\P; % orthonormal projector
    elseif opt.proj_norm
       P = diag(1./sqrt(diag(P*P')))*P; % normal projector
    end
    Xp = X*P';
    for i=1:d
        dis = sqrt(sq_dist(Xp(:,i)')); 
        hyptest.cov(2 * (i-1) + 1) = log(median(dis(:))); 
    end
    if num_steps > 0 
        hyptest = minimize(hyptest,@gp,-num_steps, varargin{:});
    end
    nlml = gp(hyptest, varargin{:});

    if nlml < nlml_best
     hyp = hyptest;
     nlml_best = nlml;
    end
  
end


 
 
