clear all, close all, seed = 4; randn('seed',seed); rand('seed',seed)
dev = @(x,y) max(abs(x(:)-y(:)))/max([max(abs(x(:))),max(abs(y(:))),1]);

addpath toepgrid                                              % infGrid, covGrid
opt.cg_maxit = 500; opt.cg_tol = 1e-4;                 % keep these values fixed

% n = 2e5; nu = 2e4; ns = 5e7; % FULL
n = 5e2; nu = 5e2; ns = 1e3; % REGRESSION TEST (res@end)
% n = 1e5; nu = 5e3; ns = 1e5;

cov = {@covSEiso};
sf = 1; ell = 0.5; hyp.cov = log([ell;sf]);
x = 20*rand(n,1)-10;
y = sin(x).*exp(-x.^2/(2*5^2)) + randn(n,1)/20;
mean = {@meanLinear}; hyp.mean = 0.2;
lik = {@likGauss}; sn = 0.3;  hyp.lik = log(sn);

xs = linspace(-12,14,ns)';
xg = {{linspace(-11,13,nu)'}};
covg = {@covGrid,cov,xg};
tic
[post nlZ dnlZ] = infGrid(hyp,mean,covg,lik,x,y,opt);
[fmu,fs2,ymu,ys2] = post.predict(xs);
t = toc;
s = sprintf('n=%1.1g, nu=%1.1g, ns=%1.1g: tgrid=%1.1fs\n',n,nu,ns,t);
p = strfind(s,'+0');
for i = p(end:-1:1), s = [s(1:i-1),s(i+2:end)]; end
fprintf(s)

if n<2e3 && n==nu
  pars = {lik,xg{1}{1},y};
  [poste nlZe dnlZe] = infExact(hyp,mean,cov, pars{:});
  [postt nlZt dnlZt] = infToep( hyp,mean,cov, pars{:});
  [postg nlZg dnlZg] = infGrid( hyp,mean,covg,pars{:},opt);
  dt = max([dev(postt.alpha,poste.alpha);
            dev(postt.sW,poste.sW); dev(nlZt,nlZe);
            dev(unwrap(dnlZt),unwrap(dnlZe))]);
  dg = max([dev(postg.alpha,poste.alpha);
            dev(postg.sW,poste.sW)]);
  [dt,dg]
  [nlZe,nlZg,nlZt]
end

if n<=5e2 && nu<=5e2
  dnlZn = 0*unwrap(hyp); h = 1e-4;
  for i=1:numel(dnlZn)
    hyp_h = unwrap(hyp); hyp_h(i) = hyp_h(i)+h; hyp_h = rewrap(hyp,hyp_h);
    [post_h nlZ_h] = infGrid(hyp_h,mean,covg,lik,x,y,opt);
    dnlZn(i) = (nlZ_h-nlZ)/h;
  end
  fprintf('  derivative err=%1.1e\n',dev(dnlZn,unwrap(dnlZ)))
  opt.cg_tol = 1e-7;
  [postg nlZg dnlZg] = infGrid(hyp,mean,{@covGrid,cov,xg{1}},lik,x,y,opt);
  errg = [dev(postg.alpha,post.alpha),dev(nlZg,nlZ)];
  [poste nlZe dnlZe] = infExact(hyp,mean,cov,lik,x,y);
  erre = [dev(poste.alpha,post.alpha),dev(nlZe,nlZ)];
  [errg(1),erre(1)]
  [errg(2),erre(2)]
end
plot(x,y,'.'), hold on, plot(xs,ymu,'-r')
rmpath toepgrid

% regression test
% test_infGrid_toep
% n=5e2, nu=5e2, ns=1e3: t=0.5s
%   der err=3.7e-03
% 
% ans =
% 
%    1.0e-03 *
% 
%     0.5639    0.5529
% 
% 
% ans =
% 
%     0.0734    0.3821