clear all, close all, seed = 4; randn('seed',seed); rand('seed',seed)
dev = @(x,y) max(abs(x(:)-y(:)))/max([max(abs(x(:))),max(abs(y(:))),1]);
addpath toepgrid                                                % shadow covGrid

cs = 2;                                              % toggle between test cases
if cs==1                                         % toggle between two test cases
  nx = [9,11,5]; Dx = [1,2,3]; xg = cell(numel(nx),1);  % grid data generation
  for i=1:numel(nx), xg{i} = randn(nx(i),Dx(i)); end
  x = covGrid('expand',xg);                                          % full data
  cov = {{@covSEard},{@covRQard},{@covSEiso}};
  hyp.cov = rand(eval(covGrid(cov,xg)),1);
  y = x(:,1).^2 + x(:,2) - log(abs(x(:,3)));
elseif cs==2
  nx = [37,35]; Dx = [1,1]; xg = {linspace(0,2,nx(1))',linspace(0,2,nx(2))'};
  [x2,x1] = meshgrid(xg{2},xg{1});
  x = [x1(:),x2(:)]; clear x1 x2
  cov = {{@covSEiso},{@covSEiso}};
  hyp.cov = zeros(4,1);
  y = x(:,1).^2 + x(:,2);
%   xg = {{xg{1}},{xg{2}}};
  xg = {{xg{1},xg{2}}}; cov = {{@covSEiso}}; hyp.cov = zeros(2,1);
else
  nx = 250; Dx = 1;
  xg = {linspace(0,2,nx)'};
  x = xg{1}; x = x+0.2*(x(2)-x(1));
  cov = {@covSEiso};
  hyp.cov = zeros(2,1);
  y = x.^2 + x;
  % xg = {xg};
end

% prediction needs to be accurate all the times, nlZ and dnlZ are approximate
N = prod(nx); idx = (1:2:N)';
mean = {@meanConst}; hyp.mean = 0.2; y = y(idx);
z = randn(56,sum(Dx));
sn = 0.1;  hyp.lik = log(sn); lik = {@likGauss};                    % nlZ exact
% lik = {@likErf}; hyp.lik = []; y = sign(y-median(y));
% lik = {@likPoisson,'logistic'}; y = floor(exp(y)); hyp.lik = [];

cv = cell(size(cov));                   % full covariance via pointwise products
for i=1:numel(cv), cv{i} = {@covMask,{sum(Dx(1:i-1))+(1:Dx(i)),cov{i}}}; end
cv = {@covProd,cv}; j = 1;

opt.nlZ_exact = 0;          % use dense computations instead of scalable algebra
opt.pred_var = 20;                       % fast predictive variance computations
opt.cg_maxit = 500; opt.cg_tol = 1e-4; opt.stat = true;

idz = (1:3:N)';
tic
  [nlZ dnlZ post]   = gp(hyp, @infLaplace, mean, cv, lik, x(idx,:), y);
  [ymu ys2 fmu fs2] = gp(hyp, @infLaplace, mean, cv, lik, x(idx,:), y, x(idz,:));
fprintf('dense inf/pred took %3.1fs\n',toc)
covg = {@covGrid,cov,xg};
tic
  [postg nlZg dnlZg] = infGrid_Laplace(hyp, mean, covg, lik, idx, y, opt);
  [ymug ys2g fmug fs2g] = gp(hyp, @infGrid_Laplace, mean, covg, lik, idx, postg, idz);
fprintf('grid inf/pred took %3.1fs\n',toc)
[fmugf,fs2gf,ymugf,ys2gf] = postg.predict(idz);
[nlZ,nlZg]

err = [dev(postg.alpha,post.alpha),dev(postg.sW,post.sW)];
fprintf('verify infGrid inference  %1.3e\n',sum(err))
fprintf('verify infGrid nlZ        %1.3e\n',dev(nlZ,nlZg))
fprintf('verify infGrid dnlZ       %1.3e\n',dev(unwrap(dnlZ),unwrap(dnlZg)))
err = [dev(ymu,ymug), dev(ys2,ys2g), dev(fmu,fmug), dev(fs2,fs2g)];
fprintf('verify infGrid prediction %1.3e\n',sum(err))