clear all, close all, seed = 4; randn('seed',seed); rand('seed',seed)
dev = @(x,y) max(abs(x(:)-y(:)))/max([max(abs(x(:))),max(abs(y(:))),1]);

test = [1,1,1,1,1,1];

if test(1)                                       % grid conversion functionality
  fprintf('grid conversion (modes 1 and 2)\n')
  nx = [15,4,16,5]; Dx = [1,1,1,1]; xg = cell(numel(nx),1);
  for i=1:numel(nx), xg{i} = randn(nx(i),Dx(i)); end
  [z,nz,Dz]  = covGrid('expand',xg);
  [a,b,c,d] = ndgrid(xg{:}); x = [a(:),b(:),c(:),d(:)];
  err = dev(x,z)+dev(nx,nz)+dev(Dx,Dz);
  fprintf('  expand=ndgrid  (p=%d) %1.2e\n',numel(nx),err)
  if err>1e-10, error('Problem here.'), end
  zg = covGrid('factor',{z,nz,Dz});
  err = 0; for i=1:numel(nx), err = err+dev(zg{i},xg{i}); end
  fprintf('  factor(expand) (p=%d) %1.2e\n',numel(nx),err)
  if err>1e-10, error('Problem here.'), end

  nx = [2,4]; Dx = [1,1]; xg = cell(numel(nx),1);
  for i=1:numel(nx), xg{i} = randn(nx(i),Dx(i)); end
  [z,nz,Dz]  = covGrid('expand',xg);
  [a,b] = meshgrid(xg{:}); vec = @(x) x(:); x = [vec(a'),vec(b')];
  err = dev(x,z)+dev(nx,nz)+dev(Dx,Dz);
  fprintf('  expand=ndgrid  (p=%d) %1.2e\n',numel(nx),err)
  if err>1e-10, error('Problem here.'), end
  zg = covGrid('factor',{z,nz,Dz});
  err = 0; for i=1:numel(nx), err = err+dev(zg{i},xg{i}); end
  fprintf('  factor(expand) (p=%d) %1.2e\n',numel(nx),err)
  if err>1e-10, error('Problem here.'), end

  nx = [6,9,11,5,2]; Dx = [3,2,1,4,2]; xg = cell(numel(nx),1);
  for i=1:numel(nx), xg{i} = randn(nx(i),Dx(i)); end
  [z,nz,Dz]  = covGrid('expand',xg);
  zg  = covGrid('factor',{z,nz,Dz});
  err = 0; for i=1:numel(nx), err = err+dev(zg{i},xg{i}); end
  err = err+dev(nx,nz)+dev(Dx,Dz);
  fprintf('  factor(expand) (p=%d) %1.2e\n',numel(nx),err)
  if err>1e-10, error('Problem here.'), end
end

if test(2)                                                  % diagonal exactness
  fprintf('diagonal eval exactness\n')
  for j=1:2
    if j==1          % offset of first xg element per dimension for non-Toeplitz
      fprintf('  block Toeplitz\n'); d1 = 0.0;
    else
      fprintf('  Kronecker\n'); d1 = 0.1;
    end
    cov = {@covSEiso}; hyp = [-1;0.7];
    xg = {linspace(-1,1,17)'};
    for i=1:numel(xg), xg{i}(1) = xg{i}(1)+d1; end
    x = randn(100,1);
    k = covGrid(cov,xg,hyp,x,'diag');
    K = feval(cov{:},hyp,x);
    if dev(k,diag(K))>1e-12, error('Bad diagonal.'), end
    cov = {@covSEiso,@covSEiso}; hyp = [-1;0.5;-1;0.6];
    xg = {linspace(-1,1,17)',linspace(-2,2,12)'};
    for i=1:numel(xg), xg{i}(1) = xg{i}(1)+d1; end
    x = randn(100,2);
    k = covGrid(cov,xg,hyp,x,'diag');
    K = feval(cov{1},hyp(1:2),x(:,1)).*feval(cov{2},hyp(3:4),x(:,2));
    if dev(k,diag(K))>1e-12, error('Bad diagonal.'), end
  end
end

if test(3)                                                         % derivatives
  fprintf('derivatives\n')
  for cs=1:3
    if cs==1
      nx = [9,11,5]; Dx = [1,2,3]; xg = cell(numel(nx),1);% grid data generation
      for i=1:numel(nx), xg{i} = randn(nx(i),Dx(i)); end
      x = covGrid('expand',xg);                                      % full data
      cov = {{@covSEard},{@covRQard},{@covSEiso}};
      hyp = rand(eval(covGrid(cov,xg)),1);
      y = x(:,1).^2 + x(:,2) - log(abs(x(:,3)));
    elseif cs==2
      nx = [37,35]; Dx = [1,1]; xg = {linspace(0,2,nx(1))',linspace(0,2,nx(2))'};
      [x2,x1] = meshgrid(xg{2},xg{1});
      x = [x1(:),x2(:)]; clear x1 x2
      cov = {{@covSEiso},{@covSEiso}};
      hyp = zeros(4,1);
      y = x(:,1).^2 + x(:,2);
    else
      nx = 950; Dx = 1;
      xg = {linspace(0,2,nx)'};
      x = xg{1}; x = x+0.2*(x(2)-x(1));
      cov = {@covSEiso};
      hyp = zeros(2,1);
      y = x.^2 + x;  
    end
    fprintf('  case %d, p=%d\n',cs,sum(Dx))
    N = prod(nx); idx = (1:2:N)';
    z = randn(56,sum(Dx)); zi = randi(N,56,1);

    cv = cell(size(cov));               % full covariance via pointwise products
    for i=1:numel(cv), cv{i} = {@covMask,{sum(Dx(1:i-1))+(1:Dx(i)),cov{i}}}; end
    cv = {@covProd,cv}; j = 1;

    K  = feval(cv{:}, hyp, x);
    [Kg,Mx,xe] = covGrid(cov, xg, hyp, idx);   % full covariance matrix via kron   
    if isstruct(Kg), Kg = struct2cell(Kg.kron); end

    dK   = feval(cv{:}, hyp, x, [],     j);
    dgK  = feval(cv{:}, hyp, x(idx,:), 'diag');
    ddgK = feval(cv{:}, hyp, x(idx,:), 'diag', j);
    Kz   = feval(cv{:}, hyp, x(idx,:), z);
    Kzi  = feval(cv{:}, hyp, x(idx,:), x(zi,:));
    dKz  = feval(cv{:}, hyp, x(idx,:), z,      j);
    dKzi = feval(cv{:}, hyp, x(idx,:), x(zi,:),j);
    dKg  = covGrid(cov, xg, hyp, idx, [], j);
    if isstruct(dKg), dKg=struct2cell(dKg.kron); end
    for i=1:numel(Kg)                                          % expand Toeplitz
      if iscell(Kg{i}) && strcmp(Kg{i}{1},'toep')
        ni = length(xg{i});
        Kg{i} = toeplitz(Kg{i}{2}(1:ni)); dKg{i} = toeplitz(dKg{i}{2}(1:ni));
      end
    end
    dgKg  = covGrid(cov, xg, hyp, idx, 'diag');
    ddgKg = covGrid(cov, xg, hyp, idx, 'diag', j);
    Kzg   = covGrid(cov, xg, hyp, idx, z);
    Kzig  = covGrid(cov, xg, hyp, idx, zi);
    dKzg  = covGrid(cov, xg, hyp, idx, z,      j);
    dKzig = covGrid(cov, xg, hyp, idx, zi,     j);
    dK1 = 1; for i=1:numel(dKg), dK1 = kron(dKg{i},dK1); end
    K1 = 1; for i=1:numel(Kg), K1 = kron(Kg{i},K1); end

    err = dev(dgK,dgKg)+dev(K,K1)+dev(Kzi,Kzig);
    fprintf('  matrix construction %1.3e\n',err), assert(err<1e-11)
    err = dev(Kz,Kzg);
    fprintf('  interpolated cross terms %1.3e\n',err), assert(err<7e-3)
    err = dev(ddgK,ddgKg) + dev(dK,dK1) + dev(dKzi,dKzig);
    fprintf('  derivatives %1.3e\n',err), assert(err<1e-11)
    err = dev(dKz,dKzg);
    fprintf('  interpolated derivatives %1.3e\n',err), assert(err<7e-3)
  end
end

if test(4)                                               % on-grid interpolation
  addpath toepgrid
  fprintf('on-grid interpolation Mx=I\n')
  for j=1:2
    if j==1          % offset of first xg element per dimension for non-Toeplitz
      fprintf('  block Toeplitz\n'); d1 = 0.0;
    else
      fprintf('  Kronecker\n'); d1 = 0.1;
    end
    cov = {@covSEiso}; hyp = [-1;0];
    xg = {linspace(-1,1,17)'};
    for i=1:numel(xg), xg{i}(1) = xg{i}(1)+d1; end
    x = covGrid('expand',xg); n = size(x,1);
    [K,Mx] = covGrid(cov,xg,hyp,[x-1e-10;-100;100]);
    z = zeros(1,n-1); E = [eye(n);1,z;z,1];
    if norm(Mx-E,'fro')>1e-5, imagesc(Mx), error('Interpolation not unity.'),end
    cov = {@covSEiso,@covSEiso}; hyp = [-1;0;-1;0];
    xg = {linspace(-1,1,17)',linspace(-2,2,12)'};
    for i=1:numel(xg), xg{i}(1) = xg{i}(1)+d1; end
    x = covGrid('expand',xg); n = size(x,1);
    [K,Mx] = covGrid(cov,xg,hyp,x);
    if norm(Mx-eye(n))>1e-10, imagesc(Mx), error('Interpolation not unity.'),end
    cov = {@covSEiso,@covSEiso,@covSEiso}; hyp = [-1;0; -1;0; 1;0];
    xg = {linspace(-1,1,6)',linspace(-2,2,5)',linspace(-2,2,8)'};
    for i=1:numel(xg), xg{i}(1) = xg{i}(1)+d1; end
    x = covGrid('expand',xg); n = size(x,1);
    [K,Mx] = covGrid(cov,xg,hyp,x);
    if norm(Mx-eye(n))>1e-10, imagesc(Mx), error('Interpolation not unity.'),end
  end 
  rmpath toepgrid
end

if test(5)                                         % interpolation functionality
  addpath toepgrid
  fprintf('interpolation functionality\n')
  for j=1:2
    if j==1, fprintf('  equispaced\n'), else fprintf('  non-equispaced\n'), end
    xg = {linspace(-2,2,51)'};
    if j~=1, xg{1}(1) = -2.05; end
    x = 3*(sort(rand(320,1))-0.5);
    cov = {@covSEiso};
    hyp = [-1;0];
    K = feval(cov{:},hyp,x); clims = [min(K(:)),max(K(:))];
    [k,Mx] = covGrid(cov,xg,hyp,x); if isstruct(k), k = struct2cell(k.kron); end
    if isnumeric(k{1}), Kg = k{1}; else Kg = toeplitz(k{1}{2}(1:length(xg{1}))); end
    Kt = Mx*Kg*Mx';
    figure
    subplot(331), imagesc(K,clims),   title('exact K_1'), colorbar
    subplot(332), imagesc(Kt,clims),  title('inter K_1'), colorbar
    subplot(333), imagesc(abs(K-Kt)), title('diff  K_1'), colorbar
    er = dev(K,Kt);
    fprintf('   |K-Kt|=%1.3e\n',er)
    if er>4.9e-4 && j==1, error('Problem here.'), end
    if er>1.2e-2 && j==2, error('Problem here.'), end
    er = max(abs(Mx*ones(size(Mx,2),1)-1));
    fprintf('   s=1/1d=%1.3e\n',er), if er>1e-10, error('Problem here.'), end

    xg = {linspace(-2.5,2.5,19)',linspace(-2.5,2.5,14)'};
    if j~=1, xg{2}(1) = -2.55; end
    x = 2*(rand(250,2)-0.5);
    cov = {{@covSEiso},{@covSEiso}};
    hyp = [-0.5;0.2;-0.2;0.1];
    K = feval(cov{1}{:},hyp(1:2),x(:,1)).*feval(cov{2}{:},hyp(3:4),x(:,2));
    clims = [min(K(:)),max(K(:))];
    [k,Mx] = covGrid(cov,xg,hyp,x); if isstruct(k), k = struct2cell(k.kron); end
    n1 = length(xg{1}); n2 = length(xg{2});
    if isnumeric(k{1}), Kg1 = k{1}; else Kg1 = toeplitz(k{1}{2}(1:n1)); end
    if isnumeric(k{2}), Kg2 = k{2}; else Kg2 = toeplitz(k{2}{2}(1:n2)); end
    Kt = Mx*kron(Kg2,Kg1)*Mx';
    subplot(334), imagesc(K,clims),   title('exact K_1'), colorbar
    subplot(335), imagesc(Kt,clims),  title('inter K_1'), colorbar
    subplot(336), imagesc(abs(K-Kt)), title('diff  K_1'), colorbar
    er = dev(K,Kt);
    fprintf('   |K-Kt|=%1.3e\n',er)
    if er>1.2e-2 && j==1, error('Problem here.'), end
    if er>5.8e-2 && j==2, error('Problem here.'), end
    er = max(abs(Mx*ones(size(Mx,2),1)-1));
    fprintf('   s=1/2d=%1.3e\n',er),  if er>1e-10, error('Problem here.'), end

    xg = {linspace(-2.5,2.5,19)',linspace(-2.5,2.5,14)',linspace(-2.5,2.5,12)'};
    if j~=1, xg{2}(1) = 2.55; end
    x = 3*(rand(250,3)-0.5);
    cov = {{@covSEiso},{@covSEiso},{@covSEiso}};
    hyp = [-0.5;0; -0.2;0.3; -0.4;-0.2];
    K = feval(cov{1}{:},hyp(1:2),x(:,1)).*feval(cov{2}{:},hyp(3:4),x(:,2))...
                                        .*feval(cov{3}{:},hyp(5:6),x(:,3));
    clims = [min(K(:)),max(K(:))];
    [k,Mx] = covGrid(cov,xg,hyp,x); if isstruct(k), k = struct2cell(k.kron); end
    n1 = length(xg{1}); n2 = length(xg{2}); n3 = length(xg{3});
    if isnumeric(k{1}), Kg1 = k{1}; else Kg1 = toeplitz(k{1}{2}(1:n1)); end
    if isnumeric(k{2}), Kg2 = k{2}; else Kg2 = toeplitz(k{2}{2}(1:n2)); end
    if isnumeric(k{3}), Kg3 = k{3}; else Kg3 = toeplitz(k{3}{2}(1:n3)); end
    Kt = Mx*kron(kron(Kg3,Kg2),Kg1)*Mx';
    subplot(337), imagesc(K,clims),   title('exact K_1'), colorbar
    subplot(338), imagesc(Kt,clims),  title('inter K_1'), colorbar
    subplot(339), imagesc(abs(K-Kt)), title('diff  K_1'), colorbar
    er = dev(K,Kt);
    fprintf('   |K-Kt|=%1.3e\n',er)
    if er>3.5e-2 && j==1, error('Problem here.'), end
    if er>7.9e-2 && j==2, error('Problem here.'), end
    er = max(abs(Mx*ones(size(Mx,2),1)-1));
    fprintf('   s=1/3d=%1.3e\n',er),  if er>1e-10, error('Problem here.'), end
  end
  rmpath toepgrid
end

if test(6)
  addpath toepgrid
  xg = { {linspace(0,1,7)'}, rand(4,1), linspace(0,1,3)', ...
         {linspace(0,1,4)',linspace(0,1,5)'} };
  cov = {@covSEiso,@covSEiso,@covRQiso,@covGaborard};
  hyp = [-1;0.7; -1;0.7; -1;0.7;0; -0.5;-0.3;0;0];
  [x,nx,Dx]  = covGrid('expand',xg);
  cv = cell(size(cov));                 % full covariance via pointwise products
  for i=1:numel(cv), cv{i} = {@covMask,{sum(Dx(1:i-1))+(1:Dx(i)),cov{i}}}; end
  cv = {@covProd,cv};
  K  = feval(cv{:}, hyp, x);
  idx = (1:prod(nx))';
  [Kg,Mx,xe] = covGrid(cov, xg, hyp, idx);
  if isstruct(Kg), Kg=struct2cell(Kg.kron); end
  [dKg,dMx,dxe] = covGrid(cov, xg, hyp, idx, [], 1);
  if isstruct(dKg), dKg=struct2cell(dKg.kron); end
  L = 1;
  for i=1:numel(Kg)
    Ki = Kg{i}; if isstruct(Ki), Ki = Ki.mvm(eye(nx(i))); end
    L = kron(Ki,L);
  end
  if dev(K,L)>1e-10, error('Problem here.'), end
  rmpath toepgrid
end