function y = sample_gp(x)
n = size(x, 1);
hyp_true.cov = log([1., 1.]);
covfunc = @covSEiso;
hyp_true.lik = log(0.1);
likfunc = @likGauss;
hyp_true.mean = [];
meanfunc = @meanZero;

K = feval(covfunc, hyp_true.cov, x);
L = chol(K + 1e-7 * eye(n));
m = feval(meanfunc, hyp_true.mean, x);
y = m + L' * randn(n, 1) + randn(n, 1) * exp(hyp_true.lik);

end
