function [res] = proj_gauss(D, d, dp, n, ns, ng, trans, restrictP)
res = struct;
% Generate inputs
if nargin < 4
    n = 100;
end
if nargin < 5
    ns = 100;
end
if nargin < 6
    ng = 50;
end
if nargin < 7
    trans = true;
end
if nargin < 8
    restrictP = 0;
end
%n = 100;
%ns = 100;
%d = 2;
%D = 4;
[Vall, Xall, P, Pc] = gen_normal_data(n + ns, D, d, trans);
V = Vall(1:n,:);
Vs = Vall(n+1:end, :);
X = Xall(1:n, :);
Xs = Xall(n+1:end, :);
% Generate outputs by sampling from a GP in the subspace
yall = sample_gp(Vall);
y = yall(1:n);
ys = yall(n+1:end);

% Setup fast GP
opt.cg_maxit = 2e4; 
opt.cg_tol = 1e-4; 
opt.proj_ortho = restrictP > 1;
opt.proj_norm = restrictP > 0;
%dp = 2;
meanfunc = {@meanZero}; 
hyp.mean = [];
lik = {@likGauss};   hyp.lik = log(0.1);
sf = 1; ell = 1; 
hyp.cov = zeros(2 * dp, 1);
nx = ones(dp, 1) * ng;
cov = {};
for i=1:dp
    hyp.cov(2 * (i-1)+1:2*i) = log([ell; sf]);
    cov{i} = {@covSEiso};
end
P_init = randn(dp, D);
hyp.P = P_init;
if opt.proj_ortho
    hyp.P = sqrtm(hyp.P * hyp.P')\hyp.P
elseif opt.proj_norm
    hyp.P = diag(1./sqrt(diag(hyp.P*hyp.P')))*hyp.P;                      
end
xg = covGrid('create', X * hyp.P', 1, ng);
%xg = {{xg{1}}, {xg{2}}};
covg = {@covGrid,cov,xg};

par = {meanfunc,covg,lik};
inf_method = @(varargin) infGrid(varargin{:},opt);
tic
% Initialize projection by randomly sampling and keeping best wrt ML
hyp = proj_init(20, 50, hyp, inf_method, meanfunc, covg, lik, X, y);
if opt.proj_ortho
    hyp.P = sqrtm(hyp.P * hyp.P')\hyp.P
elseif opt.proj_norm
    hyp.P = diag(1./sqrt(diag(hyp.P*hyp.P')))*hyp.P;                      
end
xg = covGrid('create', X * hyp.P', 1, ng);
%xg = {{xg{1}}, {xg{2}}};
covg = {@covGrid,cov,xg};
par = {meanfunc,covg,lik};
% Optimize hyperparameters
iters = 300;
hyp = minimize(hyp,@gp,-iters, inf_method, meanfunc, covg, lik, X, y);
if opt.proj_ortho
    hyp.P = sqrtm(hyp.P * hyp.P')\hyp.P
elseif opt.proj_norm
    hyp.P = diag(1./sqrt(diag(hyp.P*hyp.P')))*hyp.P;                      
end
xg = covGrid('create', Xall * hyp.P', 1, ng);
%xg = {{xg{1}}, {xg{2}}};
covg = {@covGrid,cov,xg};
par = {meanfunc,covg,lik};
t_train = toc
tic
% Predict on hold-out
[post nlZ dnlZ] = infGrid(hyp,par{:},X, y, opt);
Xsp = Xs * hyp.P';
Xp = X * hyp.P';
y_fast = post.predict(Xsp);
[y_slow ~] = gp(hyp,@infGrid,par{:},Xp, post,Xs * hyp.P');
res.rmse_slow = sqrt(sum(ys - y_slow).^2 / ns);
res.rmse_fast = sqrt(sum(ys - y_fast).^2 / ns);
toc
P_pred = orth(hyp.P')';
P;
if d == dp
    res.dis = norm(P_pred * Pc', 2);
else
    res.dis = nan;
end

hyp_full.mean = [];
hyp_full.lik = log(0.1);
hyp_full.cov = log([1., 1.]);
par_full = {@meanZero, @covSEiso, @likGauss};
tic
% Optimize hyperparameters
iters = 300;
hyp_full = minimize(hyp_full,@gp,-iters, @infExact, par_full{:}, X, y);
[y_full ~] = gp(hyp_full,@infExact,par_full{:}, X, y, Xs);
res.rmse_full = sqrt(sum(ys - y_full).^2 / ns);
t_train_full = toc
hyp_sub.mean = [];
hyp_sub.lik = log(0.1);
hyp_sub.cov = log([1., 1.]);
par_sub = {@meanZero, @covSEiso, @likGauss};
% Optimize hyperparameters
iters = 300;
hyp_sub = minimize(hyp_sub,@gp,-iters, @infExact, par_sub{:}, V, y);
[y_sub ~] = gp(hyp_sub,@infExact,par_sub{:}, V, y, Vs);
res.rmse_sub = sqrt(sum(ys - y_sub).^2 / ns);

mae_sub = mean(abs(ys - y_sub));
mae_full = mean(abs(ys - y_full));
mae_fast = mean(abs(ys - y_fast));
mae_slow = mean(abs(ys - y_slow));
mae_empm = mean(abs(ys - ones(size(ys)) * mean(y)));

res.mae_sub = mae_sub;
res.mae_full = mae_full;
res.mae_fast = mae_fast;
res.mae_slow = mae_slow;
res.mae_empm = mae_empm;
res.ys_true = ys;
res.ys_sub = y_sub;
res.ys_full = y_full;
res.ys_fast = y_fast;
res.ys_slow = y_slow;
res.y_train = y;
res.t_train = t_train;
res.t_train_full = t_train_full;
res.git_commit = evalc('system(''git rev-parse HEAD'');'); % get commit hash
res.git_commit = res.git_commit(1:end-1); % get rid of trailing newline
res.datstr = datestr(now);
res.D = D;
res.dp = dp;
res.d = d;
res.n = n;
res.ng = ng;
res.ns = ns;
res.infopt = opt;
res
