function [out] = norm_avg_proj_gauss(num_trials, varargin)

out.rmse_slow = 0.;
out.rmse_fast = 0.;
out.rmse_full = 0.;
out.rmse_sub = 0.;
out.smae_sub = 0.;
out.smae_full = 0.;
out.smae_fast = 0.;
out.smae_slow = 0.;
out.dis = 0.;
for i=1:num_trials
    res = proj_gauss(varargin{:});
    out.dis = out.dis + res.dis / num_trials;
    out.rmse_slow = out.rmse_slow + res.rmse_slow / res.rmse_slow / num_trials;
    out.rmse_fast = out.rmse_fast + res.rmse_fast / res.rmse_slow / num_trials;
    out.rmse_full = out.rmse_full + res.rmse_full / res.rmse_slow / num_trials;
    out.rmse_sub = out.rmse_sub + res.rmse_sub / res.rmse_slow / num_trials;
    out.smae_sub = out.smae_sub + res.mae_sub / res.mae_empm / num_trials;
    out.smae_full = out.smae_full + res.mae_full / res.mae_empm / num_trials;
    out.smae_fast = out.smae_fast + res.mae_fast / res.mae_empm / num_trials;
    out.smae_slow = out.smae_slow + res.mae_slow / res.mae_empm / num_trials;
end
