clear all, close all, seed = 4; randn('seed',seed); rand('seed',seed)

hyplearn = 1;
iters = 100;


% for test varying with n, may want high noise to signal ratio

%addpath toepgrid                                              % infGrid, covGrid
opt.cg_maxit = 500; opt.cg_tol = 1e-4;                 % keep these values fixed
inf_method = @(varargin) infGrid(varargin{:},opt);

n = 1e4;
nx = 1e4;
ns = 1e5;

slow = 0;

cov = {@covSEiso};
sf = 1; ell = 0.5; hyp.cov = log([ell;sf]);
x = 20*rand(n,1)-10;
y = sin(x).*exp(-x.^2/(2*5^2)) + randn(n,1)/20;
%my = mean(y);
%y = y-my;  function is naturally mean zero


%meanfunc = {@meanLinear}; hyp.mean = 0.2;
meanfunc = {@meanZero}; hyp.mean={};
lik = {@likGauss}; sn = 0.3;  hyp.lik = log(sn);

xs = linspace(-12,14,ns)';
xg = {{linspace(-14,14,nx)'}};
covg = {@covGrid,cov,xg};

tic
[post nlZ dnlZ] = infGrid(hyp,meanfunc,covg,lik,x,y,opt);
t_ml = toc;

tic
ymu = post.predict(xs);
toc

t_tst = toc;

tic
[fmu,fs2] = post.predict(xs);
t_tst_full = toc;

% slow test predictions
% only need mean predictions, symmetric likelihood
post.L = @(x) 0*x;

slow=1;
if (slow)
tic
[ymug_slow] = gp(hyp,@infGrid,meanfunc,covg,[],x,post,xs);
t_tst_slow = toc;
else
t_tst_slow = 0;
end

t_tr = 0;

if(hyplearn)
   tic;
   hyp_full = minimize(hyp,@gp,-iters,inf_method,meanfunc,covg,lik,x,y);
   t_tr = toc;
end

s = sprintf('n=%1.1g, nx=%1.1g, ns=%1.1g, t_ml=%1.1fs, t_tst=%1.1fs, t_tst_slow=%1.1fs, t_tst_full=%1.1fs, t_tr=%1.1fs\n',n,nx,ns,t_ml,t_tst,t_tst_slow,t_tst_full,t_tr);
p = strfind(s,'+0');
for i = p(end:-1:1), s = [s(1:i-1),s(i+2:end)]; end
fprintf(s)

if(slow)
figure(94); clf; plot(ymu,'b','LineWidth',2); hold on; plot(ymug_slow,'k--','LineWidth',2);
end
