clear all, close all
dev = @(x,y) max(abs(x(:)-y(:)))/max([max(abs(x(:))),max(abs(y(:))),1]);

addpath ../../../test/toepgrid                                % infGrid, covGrid

n = 1e2; nx = 20; ns = 1e5; nu = 50;

opt.cg_maxit = 500; opt.cg_tol = 1e-4;                 % keep these values fixed
opt.pred_var = 25;                % make predictive variance functions available

cov = {@covSEiso};
sf = 1.2; ell = 0.5; hyp.cov = log([ell;sf]);
x = 20*rand(n,1)-9;
y = sin(x).*exp(-x.^2/(2*5^2)) + randn(n,1)/20;
mean = {@meanLinear}; hyp.mean = 0.2;
lik = @likGauss; sn = 1.3;  hyp.lik = log(sn);

xs = linspace(-12,14,ns)';
xg = {{linspace(-11,13,nx)'}};
covg = {@covGrid,cov,xg};
[postg nlZg dnlZg] = infGrid(hyp,mean,covg,lik,x,y,opt);
[fmug fs2g ymug ys2g] = postg.predict(xs);
xu = 26*rand(nu,1)-12; covf = {@covFITC,cov,xu};
[postf nlZf dnlZf] = infFITC(hyp,mean,covf,lik,x,y);
[ymuf ys2f] = gp(hyp,@infFITC,mean,covf,lik,x,postf,xs);

if n<=1e3
  [nlZ dnlZ post] = gp(hyp,@infExact,mean,cov,lik,x,y);
  [ymu ys2] = gp(hyp,@infExact,mean,cov,lik,x,post,xs);
  [unwrap(dnlZg),unwrap(dnlZ),unwrap(dnlZf)]
  subplot(131)
   fill([xs;flipud(xs)],[ymug+sqrt(ys2g);flipud(ymug-sqrt(ys2g))],[0.0,1.0,1.0])
   hold on, plot(xs,ymug,'b','LineWidth',3), plot(x,y,'bo'), title('grid')
   axis([-11 13 -3 3])
  subplot(132)
   fill([xs;flipud(xs)],[ymu+sqrt(ys2);flipud(ymu-sqrt(ys2))],[0.8,0.8,0.8])
   hold on, plot(xs,ymu,'k','LineWidth',3), plot(x,y,'ko'), title('exact')
   axis([-11 13 -3 3])
  subplot(133)
   fill([xs;flipud(xs)],[ymuf+sqrt(ys2f);flipud(ymuf-sqrt(ys2f))],[1.0,0.0,1.0])
   hold on, plot(xs,ymug,'r','LineWidth',3), plot(x,y,'ro'), title('fitc')
   axis([-11 13 -3 3])
end